/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings.browser;

import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Registry;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;
import org.luwrain.settings.browser.Settings;
import org.luwrain.settings.browser.Strings;

final class SettingsForm
extends FormArea
implements SectionArea {
    private final ControlPanel controlPanel;
    private final Luwrain luwrain;
    private final Registry registry;
    private final Settings sett;
    private final Strings strings;

    SettingsForm(ControlPanel controlPanel, Strings strings) {
        super((ControlContext)new DefaultControlContext(controlPanel.getCoreInterface()), strings.sectionName());
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        NullCheck.notNull((Object)strings, (String)"strings");
        this.controlPanel = controlPanel;
        this.luwrain = controlPanel.getCoreInterface();
        this.registry = null;
        this.sett = Settings.create(this.registry);
        this.strings = strings;
        this.fillForm();
    }

    private void fillForm() {
        this.addEdit("home-page", this.strings.homePage(), this.sett.getHomePage(""));
        this.addEdit("user-agent", this.strings.userAgent(), this.sett.getUserAgent(""));
        this.addCheckbox("java-script-enabled", this.strings.javaScriptEnabled(), this.sett.getJavaScriptEnabled(true));
    }

    public boolean saveSectionData() {
        this.sett.setHomePage(this.getEnteredText("home-page"));
        this.sett.setUserAgent(this.getEnteredText("user-agent"));
        this.sett.setJavaScriptEnabled(this.getCheckboxState("java-script-enabled"));
        return true;
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }
}

