/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.webinspector;

import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.webinspector.App;
import org.luwrain.app.webinspector.ElementsModel;
import org.luwrain.app.webinspector.WebObject;
import org.luwrain.controls.SimpleArea;
import org.luwrain.controls.TreeListArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.SystemEvent;

final class WebTreeLayout
extends LayoutBase {
    private final App app;
    final TreeListArea<WebObject> elementsArea;
    final SimpleArea stylesArea;

    WebTreeLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        TreeListArea.Params treeParams = new TreeListArea.Params();
        treeParams.context = this.getControlContext();
        treeParams.name = "Elements";
        treeParams.model = new ElementsModel(app);
        this.elementsArea = new TreeListArea<WebObject>(treeParams){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case REFRESH: {
                            app.update();
                            app.getLuwrain().playSound(Sounds.OK);
                            return true;
                        }
                        case OK: {
                            return WebTreeLayout.this.onShowStyles();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.stylesArea = new SimpleArea(this.getControlContext(), "Styles");
        this.setAreaLayout(AreaLayout.LEFT_RIGHT, (Area)this.elementsArea, null, (Area)this.stylesArea, null);
    }

    private boolean onShowStyles() {
        this.stylesArea.update(lines -> {
            lines.clear();
            lines.add("Test styles box");
        });
        return true;
    }
}

