/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.webinspector;

import com.sun.webkit.dom.DOMWindowImpl;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSObject;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.views.DocumentView;

final class ScanResult {
    final WebEngine engine;
    final JSObject src;
    final JSObject root;
    final HTMLDocument doc;
    final DOMWindowImpl window;
    final Map<Node, Item> nodes = new HashMap<Node, Item>();
    int count = 0;

    ScanResult(WebEngine engine, JSObject src) {
        Object o;
        this.engine = engine;
        this.src = src;
        this.doc = (HTMLDocument)engine.getDocument();
        this.window = (DOMWindowImpl)((DocumentView)((Object)this.doc)).getDefaultView();
        this.root = (JSObject)src.getMember("dom");
        int i = 0;
        while (!(o = this.root.getSlot(i)).getClass().equals(String.class)) {
            JSObject jsObj = (JSObject)o;
            ++this.count;
            JSObject rect = (JSObject)jsObj.getMember("rect");
            String text = (String)jsObj.getMember("text");
            Node node = (Node)jsObj.getMember("node");
            int x = -1;
            int y = -1;
            int width = -1;
            int height = -1;
            if (rect != null) {
                x = ScanResult.intValue(rect.getMember("left"));
                y = ScanResult.intValue(rect.getMember("top"));
                width = ScanResult.intValue(rect.getMember("width"));
                height = ScanResult.intValue(rect.getMember("height"));
            }
            if (!text.equals("123") && !text.isBlank()) {
                this.nodes.put(node, new Item(x, y, width, height, String.valueOf(text)));
            }
            ++i;
        }
    }

    static int intValue(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return Double.valueOf(Double.parseDouble(o.toString())).intValue();
    }

    public Map<Node, Item> getNodes() {
        return this.nodes;
    }

    public static final class Item {
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final String text;

        Item(int x, int y, int width, int height, String text) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.text = text;
        }
    }
}

