/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.linux_term;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.linux_term.TermInfo;
import org.luwrain.core.HotPoint;
import org.luwrain.core.Lines;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Sounds;

final class Terminal
implements Lines,
HotPoint {
    private static final char ESCAPE = '\u001b';
    private static final int MAX_CMD_LEN = 16;
    private static final Logger log = LogManager.getLogger();
    private final Luwrain luwrain;
    private final TermInfo termInfo;
    private List<String> lines = new ArrayList<String>();
    private int hotPointX = 0;
    private int hotPointY = 0;
    private StringBuilder escapeSeq = null;

    Terminal(Luwrain luwrain, TermInfo termInfo) {
        this.luwrain = Objects.requireNonNull(luwrain, "luwrain can't be null");
        this.termInfo = Objects.requireNonNull(termInfo, "termInfo can't be null");
    }

    void termText(String text) {
        log.trace("Term text " + text.replaceAll("\b", "(BS)"));
        if (this.escapeSeq != null) {
            log.trace("Escape seq: " + new String(this.escapeSeq));
        } else {
            log.trace("No escape seq");
        }
        if (text.isEmpty()) {
            return;
        }
        if (this.lines.isEmpty()) {
            this.lines.add("");
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\u001b') {
                if (this.escapeSeq != null) {
                    this.onText("(PREV " + new String(this.escapeSeq) + ")");
                }
                this.escapeSeq = new StringBuilder();
                this.escapeSeq.append(ch);
                continue;
            }
            if (this.escapeSeq != null && this.escapeSeq.length() == 16) {
                this.onText("(LONG " + new String(this.escapeSeq) + ")" + ch);
                this.escapeSeq = null;
                continue;
            }
            if (this.escapeSeq == null) {
                this.onChar(ch);
                continue;
            }
            this.escapeSeq.append(ch);
            String s = new String(this.escapeSeq);
            Matcher m = TermInfo.DCH.matcher(s);
            if (m.find()) {
                this.onText("[DCH " + m.group(1) + "]");
                this.escapeSeq = null;
                continue;
            }
            m = TermInfo.ICH.matcher(s);
            if (m.find()) {
                this.onText("[ICH " + m.group(1) + "]");
                this.escapeSeq = null;
                continue;
            }
            String cmd = this.termInfo.find(s);
            if (cmd == null) continue;
            this.escapeSeq = null;
            this.onText("[" + cmd + "]");
        }
    }

    void onText(String text) {
        for (int i = 0; i < text.length(); ++i) {
            this.onChar(text.charAt(i));
        }
    }

    void onChar(char ch) {
        switch (ch) {
            case '\u0007': {
                return;
            }
            case '\b': {
                this.onBackspace();
                return;
            }
            case '\r': {
                return;
            }
            case '\n': {
                this.lines.add("");
                ++this.hotPointY;
                this.hotPointX = 0;
                return;
            }
        }
        this.appendText(String.valueOf(ch));
    }

    void appendText(String text) {
        this.lines.set(this.lines.size() - 1, this.lines.get(this.lines.size() - 1) + text);
        this.hotPointX += text.length();
    }

    private void speak(String text) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\u0007') {
                this.luwrain.playSound(Sounds.TERM_BELL);
                continue;
            }
            if (ch < ' ') {
                str.append(" ");
                continue;
            }
            str.append(ch);
        }
        String toSpeak = new String(str).trim();
        if (toSpeak.isEmpty()) {
            return;
        }
        if (toSpeak.length() == 1) {
            this.luwrain.speakLetter(toSpeak.charAt(0));
        } else {
            this.luwrain.speak(this.luwrain.getSpeakableText(toSpeak, Luwrain.SpeakableTextType.PROGRAMMING));
        }
    }

    public int getHotPointX() {
        return this.hotPointX;
    }

    public int getHotPointY() {
        return this.hotPointY;
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public String getLine(int index) {
        if (index >= this.lines.size()) {
            return "";
        }
        return this.lines.get(index);
    }

    void onBackspace() {
        if (this.hotPointX == 0) {
            return;
        }
        if (this.hotPointY >= this.lines.size()) {
            log.warn("Hot point Y is outside of text area");
            return;
        }
        String line = this.lines.get(this.hotPointY);
        this.hotPointX = Math.min(this.hotPointX, line.length());
        char ch = line.charAt(this.hotPointX - 1);
        this.lines.set(this.hotPointY, line.substring(0, this.hotPointX - 1) + line.substring(this.hotPointX));
        --this.hotPointX;
    }
}

