/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.linux_term;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.luwrain.linux.ShellCmd;

final class TermInfo {
    static final Pattern DCH = Pattern.compile("\u001b\\[([0-9]+)P");
    static final Pattern ICH = Pattern.compile("\u001b\\[([0-9]+)@");
    final Map<String, String> seq = new HashMap<String, String>();

    TermInfo() {
        ShellCmd cmd = new ShellCmd("TERM=linux infocmp", "/");
        int exitCode = cmd.waitFor();
        if (exitCode != 0) {
            throw new RuntimeException("infocmp exited with exit code " + exitCode);
        }
        this.parse(cmd.output.stream().filter(e -> !e.trim().isEmpty() && e.trim().charAt(0) != '#').collect(Collectors.joining(" ")));
    }

    private void parse(String text) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ',' && (i == 0 || text.charAt(i - 1) != '\\')) {
                this.parseItem(new String(b));
                b = new StringBuilder();
                continue;
            }
            if (c == ' ' && b.length() == 0) continue;
            b.append(c);
        }
    }

    private void parseItem(String item) {
        int eqPos = item.indexOf("=");
        if (eqPos < 0) {
            return;
        }
        String name = item.substring(0, eqPos);
        String value = item.substring(eqPos + 1).replaceAll("\\\\E", String.valueOf('\u001b')).replaceAll("\\\\,", ",").replaceAll("\\\\r", String.valueOf('\r')).replaceAll("\\\\n", String.valueOf('\n'));
        if (value.indexOf("%") >= 0) {
            return;
        }
        this.seq.put(value, name);
    }

    String find(String s) {
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("s can't be empty");
        }
        return this.seq.get(s);
    }
}

