/*
 * Decompiled with CFR 0.152.
 */
package speechd.ssip;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import speechd.ssip.SSIPCommand;
import speechd.ssip.SSIPCommandException;
import speechd.ssip.SSIPCommunicationException;
import speechd.ssip.SSIPDataException;
import speechd.ssip.SSIPEventHandler;
import speechd.ssip.SSIPEventParser;
import speechd.ssip.SSIPException;
import speechd.ssip.SSIPResponse;

public class SSIPConnection {
    private static final String CRLF = "\r\n";
    private static final String END_OF_DATA = "\r\n.\r\n";
    private Socket _socket;
    private BufferedReader _reader;
    private BufferedWriter _writer;
    private String _host;
    private int _port;
    private boolean _connected;
    private SSIPResponse _currentResponse;
    private Thread _thread;
    private SSIPEventHandler _eventHandler = null;
    private Logger _logger = Logger.getLogger("speechd.ssip.SSIPConnection");

    public SSIPConnection(String host, int port) {
        this._host = host;
        this._port = port;
        this._connected = false;
        this._socket = null;
        this._logger.log(Level.FINEST, "created connection");
    }

    public void connect() throws SSIPException {
        try {
            this._socket = new Socket(this._host, this._port);
            this._logger.log(Level.INFO, String.format("connected to %s port %d", this._host, this._port));
            this._socket.setTcpNoDelay(true);
            this._reader = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
            this._writer = new BufferedWriter(new OutputStreamWriter(this._socket.getOutputStream()));
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, String.format("I/O error connecting to %s port %d: %s", this._host, this._port, e.getMessage()));
            throw new SSIPCommunicationException("can't connect to host");
        }
        this._connected = true;
        this._thread = new Thread(new InputThread());
        this._thread.setDaemon(true);
        this._thread.start();
        this._logger.log(Level.INFO, "started communications thread");
    }

    public void disconnect() {
        if (!this._connected) {
            return;
        }
        this._connected = false;
        try {
            this._logger.log(Level.FINE, "joining communications thread");
            this._thread.join();
            this._socket.close();
            this._logger.info("disconnected from host");
        }
        catch (InterruptedException e) {
            this._logger.log(Level.WARNING, "interrupted exception when disconnecting", e);
        }
        catch (IOException e) {
            this._logger.log(Level.WARNING, "I/O exception when disconnecting", e);
        }
        finally {
            this._thread = null;
            this._socket = null;
        }
    }

    public synchronized SSIPResponse sendCommand(SSIPCommand command) throws SSIPCommandException, SSIPCommunicationException {
        if (!this._connected) {
            throw new SSIPCommunicationException("not connected to server");
        }
        try {
            this._logger.log(Level.FINE, "Sending command %s", command.toString());
            this._writer.write(command.toString());
            this._writer.write(CRLF);
            this._writer.flush();
            this._logger.log(Level.FINE, "command sent");
            SSIPResponse res = null;
            this._logger.fine("receiving response");
            while (this._currentResponse == null) {
                this.wait();
                res = this._currentResponse;
                this._logger.fine(String.format("Received response %s", res));
            }
            this._currentResponse = null;
            if (res.getCode() / 100 != 2) {
                this._logger.warning(String.format("Error code %d returned from server", res.getCode()));
                throw new SSIPCommandException(command, res);
            }
            return res;
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "I/O when sending command", e);
            this.disconnect();
            throw new SSIPCommunicationException("disconnected from server");
        }
        catch (InterruptedException e) {
            this._logger.log(Level.SEVERE, "Communications thread interrupted when sending command");
            this.disconnect();
            throw new SSIPCommunicationException(e);
        }
    }

    public synchronized SSIPResponse sendData(String data) throws SSIPDataException, SSIPCommunicationException {
        if (!this._connected) {
            throw new SSIPCommunicationException("not connected to server");
        }
        String dataEscaped = this.escapeData(data);
        try {
            this._writer.write(dataEscaped);
            this._writer.write(END_OF_DATA);
            this._writer.flush();
            SSIPResponse res = null;
            while (this._currentResponse == null) {
                this.wait();
                res = this._currentResponse;
            }
            this._currentResponse = null;
            if (res.getCode() / 100 != 2) {
                throw new SSIPDataException(data, res);
            }
            return res;
        }
        catch (IOException e) {
            this.disconnect();
            throw new SSIPCommunicationException(e);
        }
        catch (InterruptedException e) {
            this.disconnect();
            throw new SSIPCommunicationException(e);
        }
    }

    private String escapeData(String data) {
        Object escaped = data;
        if (((String)escaped).startsWith(".")) {
            escaped = ".." + (String)escaped;
        }
        escaped = ((String)escaped).replaceAll("\r\n.", "\r\n..");
        return escaped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(SSIPResponse response) throws InterruptedException {
        if (response.getCode() / 100 == 7) {
            if (this._eventHandler != null) {
                try {
                    this._eventHandler.handleSSIPEvent(SSIPEventParser.getInstance().parse(response));
                }
                catch (Exception e) {
                    this._logger.severe(String.format("Exception in user callback: %s\n%s", e.getLocalizedMessage(), e.getStackTrace()));
                }
            }
        } else {
            SSIPConnection sSIPConnection = this;
            synchronized (sSIPConnection) {
                this._currentResponse = response;
                this.notify();
            }
        }
    }

    private String readLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        char c1 = (char)this._reader.read();
        char c2 = (char)this._reader.read();
        while (c1 != '\r' || c2 != '\n') {
            sb.append(c1);
            c1 = c2;
            c2 = (char)this._reader.read();
        }
        this._logger.finest(String.format("Read line %s", sb.toString()));
        return sb.toString();
    }

    public boolean isConnected() {
        return this._connected;
    }

    public SSIPEventHandler getEventHandler() {
        return this._eventHandler;
    }

    public void setEventHandler(SSIPEventHandler eventHandler) {
        this._eventHandler = eventHandler;
    }

    private class InputThread
    implements Runnable {
        private InputThread() {
        }

        @Override
        public void run() {
            while (SSIPConnection.this.isConnected()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                LinkedList<String> data = new LinkedList<String>();
                try {
                    while (SSIPConnection.this._reader.ready()) {
                        String line = SSIPConnection.this.readLine();
                        assert (line.length() >= 4 && (line.charAt(3) == '-' || line.charAt(3) == ' '));
                        char c = line.charAt(3);
                        int code = Integer.parseInt(line.substring(0, 3));
                        if (c == ' ') {
                            String msg = line.substring(4);
                            SSIPResponse res = data.isEmpty() ? new SSIPResponse(code, msg) : new SSIPResponse(code, msg, data);
                            SSIPConnection.this.dispatch(res);
                            continue;
                        }
                        if (c != '-') continue;
                        data.add(line.substring(4));
                    }
                    Thread.yield();
                }
                catch (IOException e) {
                    Thread.currentThread().interrupt();
                    SSIPConnection.this.disconnect();
                }
                catch (InterruptedException e) {
                    SSIPConnection.this.disconnect();
                }
            }
        }
    }
}

