/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.extensions.voiceman;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import org.luwrain.core.NullCheck;
import org.luwrain.speech.Channel;
import org.luwrain.speech.Voice;

final class Channel
implements org.luwrain.speech.Channel {
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_NAME = "voiceman";
    private static final int DEFAULT_PORT = 5511;
    private static final int DEFAULT_PITCH = 50;
    private static final int DEFAULT_RATE = 50;
    private final Socket sock;
    private final PrintStream output;

    Channel(Map<String, String> params) throws Exception {
        int port;
        Objects.requireNonNull(params, "params can't be null");
        String host = params.containsKey("host") ? params.get("host") : DEFAULT_HOST;
        if (host.isEmpty()) {
            throw new IllegalArgumentException("Empty host name given");
        }
        if (params.containsKey("port")) {
            try {
                port = Integer.parseInt(params.get("port"));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal port number: " + params.get("port"));
            }
        } else {
            port = 5511;
        }
        try {
            this.sock = new Socket(host, port);
            this.output = new PrintStream(this.sock.getOutputStream(), true, "UTF-8");
            this.output.println("M:none");
            this.output.flush();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to connect to the VoiceMan server at " + host + ":" + port + ":" + e.getMessage());
        }
    }

    public long speak(String text, Channel.Listener listener, int relPitch, int relRate, boolean cancelPrevious) {
        if (cancelPrevious) {
            this.silence();
        }
        this.sendPitch(50 + relPitch);
        this.sendRate(50 + relRate);
        this.sendText(text);
        return -1L;
    }

    public long speakLetter(char letter, Channel.Listener listener, int relPitch, int relRate, boolean cancelPrevious) {
        if (cancelPrevious) {
            this.silence();
        }
        this.sendPitch(50 + relPitch);
        this.sendRate(50 + relRate);
        this.sendLetter(letter);
        return -1L;
    }

    private void sendPitch(int value) {
        if (value < 0) {
            this.output.println("P:0");
        } else if (value > 100) {
            this.output.println("P:100");
        } else {
            this.output.println("P:" + value);
        }
        this.output.flush();
    }

    private void sendRate(int value) {
        if (value < 0) {
            this.output.println("R:0");
        } else if (value > 100) {
            this.output.println("R:100");
        } else {
            this.output.println("R:" + value);
        }
        this.output.flush();
    }

    private void sendText(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        this.output.println("T:" + text.replaceAll("\n", " "));
        this.output.flush();
    }

    private void sendLetter(char letter) {
        Object s = "L:";
        s = (String)s + letter;
        this.output.println((String)s);
        this.output.flush();
    }

    public AudioFormat[] getSynthSupportedFormats() {
        return new AudioFormat[0];
    }

    public void close() {
        if (this.output != null) {
            this.output.close();
        }
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void silence() {
        this.output.println("S:");
        this.output.flush();
    }

    public void setVoice(String name) {
    }

    public Channel.Result synth(String text, OutputStream stream, AudioFormat format, Channel.SyncParams params, Set<Channel.Flags> flags) {
        return new Channel.Result(Channel.Result.Type.NOT_IMPLEMENTED);
    }

    public String getChannelName() {
        return DEFAULT_NAME;
    }

    public String getVoiceName() {
        return "";
    }

    public Voice[] getVoices() {
        return new Voice[0];
    }
}

