/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.message;

import java.io.File;
import java.util.ArrayList;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.message.App;
import org.luwrain.app.message.Strings;
import org.luwrain.controls.FormSpellChecking;
import org.luwrain.controls.MessageArea;
import org.luwrain.core.Area;
import org.luwrain.core.LineMarks;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.Settings;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.nlp.SpellProblem;
import org.luwrain.pim.mail.Message;
import org.luwrain.util.TextUtils;

final class MainLayout
extends LayoutBase {
    final App app;
    final MessageArea messageArea;
    final FormSpellChecking spellChecking;
    boolean modified = false;

    MainLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        this.spellChecking = new FormSpellChecking(this.getLuwrain());
        Settings.PersonalInfo sett = Settings.createPersonalInfo(null);
        ArrayList<String> text = new ArrayList<String>();
        if (app.message.getText() != null) {
            text.addAll(app.message.getText());
        }
        text.add("");
        text.addAll(TextUtils.splitLinesAsList((String)sett.getSignature("")));
        MessageArea.Params params = new MessageArea.Params();
        params.context = this.getControlContext();
        params.name = ((Strings)app.getStrings()).appName();
        params.text = text.toArray(new String[text.size()]);
        params.to = app.message.getTo() != null ? app.message.getTo().trim() : "";
        String string = params.subject = app.message.getSubject() != null ? app.message.getSubject().trim() : "";
        if (app.message.getAttachments() != null) {
            params.attachments = app.message.getAttachments().toArray(new String[app.message.getAttachments().size()]);
        }
        this.messageArea = new MessageArea(params){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case OK: {
                            return app.send(MainLayout.this.getMailMessage(), false);
                        }
                        case IDLE: {
                            return MainLayout.this.onIdle();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.messageArea.getMultilineEditChangeListeners().add((area, event, lines, hotPoint) -> {
            this.modified = true;
        });
        this.messageArea.getMultilineEditChangeListeners().add(this.spellChecking);
        this.setAreaLayout((Area)this.messageArea, this.actions(new LayoutBase.ActionInfo[]{this.action("sent", ((Strings)app.getStrings()).actionSend(), () -> app.send(this.getMailMessage(), false)), this.action("attach", ((Strings)app.getStrings()).actionAttachFile(), new InputEvent(InputEvent.Special.INSERT), this::actAttachFile), this.action("delete-attachment", ((Strings)app.getStrings()).actionDeleteAttachment(), this::actDeleteAttachment)}));
    }

    private boolean actEditTo() {
        String res = this.app.getConv().editTo();
        if (res != null) {
            this.messageArea.setTo(res);
        }
        return true;
    }

    private boolean actEditCc(MessageArea area) {
        String res = this.app.getConv().editCc(area.getCc());
        if (res != null) {
            area.setCc(res);
        }
        return true;
    }

    private boolean actAttachFile() {
        File file = this.app.getConv().attachment();
        if (file == null) {
            return true;
        }
        this.messageArea.addAttachment(file.getAbsoluteFile());
        return true;
    }

    private boolean actDeleteAttachment() {
        int index = this.messageArea.getHotPointY();
        MessageArea.Attachment a = this.messageArea.getAttachmentByLineIndex(index);
        if (a == null) {
            return false;
        }
        if (!this.app.getConv().confirmAttachmentDeleting(a.getFile())) {
            return true;
        }
        this.messageArea.removeAttachmentByLineIndex(index);
        this.app.message("\u041f\u0440\u0438\u043a\u0440\u0435\u043f\u043b\u0435\u043d\u0438\u0435 " + a.getName() + " \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0438\u0437 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", Luwrain.MessageType.OK);
        return true;
    }

    private boolean onIdle() {
        if (!this.messageArea.isHotPointInMultilineEdit()) {
            return false;
        }
        MutableMarkedLines lines = this.messageArea.getMultilineEditContent();
        int x = this.messageArea.getMultilineEditHotPoint().getHotPointX();
        int y = this.messageArea.getMultilineEditHotPoint().getHotPointY();
        if (y >= lines.getLineCount()) {
            return true;
        }
        LineMarks marks = lines.getLineMarks(y);
        if (marks == null) {
            return true;
        }
        LineMarks.Mark[] atPoint = marks.findAtPos(x);
        if (atPoint == null || atPoint.length == 0) {
            return true;
        }
        for (LineMarks.Mark m : atPoint) {
            if (m.getMarkObject() == null || !(m.getMarkObject() instanceof SpellProblem)) continue;
            SpellProblem p = (SpellProblem)m.getMarkObject();
            this.app.message(p.getComment(), Luwrain.MessageType.ANNOUNCEMENT);
            return true;
        }
        return true;
    }

    private boolean isReadyForSending() {
        if (this.messageArea.getTo().trim().isEmpty()) {
            this.app.message("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", Luwrain.MessageType.ERROR);
            this.messageArea.focusTo();
            return false;
        }
        if (this.messageArea.getSubject().trim().isEmpty()) {
            this.app.message("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0442\u0435\u043c\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f", Luwrain.MessageType.ERROR);
            this.messageArea.focusSubject();
            return false;
        }
        return true;
    }

    private Message getMailMessage() {
        Message msg = new Message();
        return msg;
    }
}

