/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.mail.layouts;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.mail.App;
import org.luwrain.app.mail.Conv;
import org.luwrain.app.mail.Data;
import org.luwrain.app.mail.Strings;
import org.luwrain.app.mail.layouts.Pop3AccountLayout;
import org.luwrain.app.mail.layouts.SmtpAccountLayout;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.list.AbstractAppearance;
import org.luwrain.core.Area;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.events.InputEvent;
import org.luwrain.pim.mail.persistence.Account;

public final class AccountsLayout
extends LayoutBase {
    final App app;
    final List<Account> accounts = new ArrayList<Account>();
    final Data data;
    final ListArea<Account> accountsArea;

    public AccountsLayout(App app, LayoutBase.ActionHandler closing) {
        super((AppBase)app);
        this.app = app;
        this.data = app.getData();
        Strings s = (Strings)app.getStrings();
        this.accounts.addAll(this.data.accountDAO.getAll());
        this.accountsArea = new ListArea(this.listParams(p -> {
            p.name = s.accountsAreaName();
            p.model = new ListUtils.ListModel(this.accounts);
            p.appearance = new Appearance();
            p.clickHandler = (area, index, account) -> this.onClick((Account)account);
        }));
        this.setCloseHandler(closing);
        this.setOkHandler(closing);
        this.setAreaLayout((Area)this.accountsArea, this.actions(new LayoutBase.ActionInfo[]{this.action("insert", s.actionNewAccount(), new InputEvent(InputEvent.Special.INSERT), this::newAccount)}));
    }

    boolean onClick(Account account) {
        if (account.getType() == null) {
            account.setType(Account.Type.SMTP);
        }
        switch (account.getType()) {
            case POP3: {
                this.app.setAreaLayout(new Pop3AccountLayout(this.app, account, () -> {
                    this.app.setAreaLayout(this);
                    this.getLuwrain().announceActiveArea();
                    this.accountsArea.redraw();
                    return true;
                }));
                this.getLuwrain().announceActiveArea();
                return true;
            }
            case SMTP: {
                this.app.setAreaLayout(new SmtpAccountLayout(this.app, account, () -> {
                    this.app.setAreaLayout(this);
                    this.getLuwrain().announceActiveArea();
                    this.accountsArea.redraw();
                    return true;
                }));
                this.getLuwrain().announceActiveArea();
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown account type: " + String.valueOf(account.getType()));
    }

    boolean newAccount() {
        Conv.NewAccountType type = this.app.conv.newAccountType();
        if (type == null) {
            return true;
        }
        Account a = new Account();
        switch (type) {
            case POP3: {
                a.setType(Account.Type.POP3);
                break;
            }
            case SMTP: {
                a.setType(Account.Type.SMTP);
            }
        }
        a.setName(((Strings)this.app.getStrings()).newAccountName());
        this.data.accountDAO.add(a);
        this.accounts.clear();
        this.accounts.addAll(this.data.accountDAO.getAll());
        this.accountsArea.refresh();
        this.accountsArea.select((Object)a, false);
        return true;
    }

    final class Appearance
    extends AbstractAppearance<Account> {
        Appearance() {
        }

        public void announceItem(Account account, Set<ListArea.Appearance.Flags> flags) {
            AccountsLayout.this.app.setEventResponse(DefaultEventResponse.listItem((String)account.getName()));
        }

        public String getScreenAppearance(Account account, Set<ListArea.Appearance.Flags> flags) {
            return account.getName();
        }
    }
}

