/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.windows;

import com.google.auto.service.AutoService;
import java.awt.Desktop;
import java.nio.file.Path;
import org.luwrain.core.Braille;
import org.luwrain.core.InitResult;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.core.OperatingSystem;
import org.luwrain.core.PropertiesBase;
import org.luwrain.interaction.KeyboardHandler;
import org.luwrain.windows.KeyboardJavafxHandler;

@AutoService(value={OperatingSystem.class})
public final class Windows
implements OperatingSystem {
    public String escapeString(String style, String str) {
        return str;
    }

    public InitResult init(PropertiesBase props) {
        return new InitResult();
    }

    public Braille getBraille() {
        return null;
    }

    public void openFileInDesktop(Path path) {
        if (!Desktop.isDesktopSupported()) {
            throw new UnsupportedOperationException("This OS does not support for Desktop");
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.OPEN)) {
            throw new UnsupportedOperationException("This OS does not support for Desktop action OPEN");
        }
        try {
            desktop.open(path.toFile());
        }
        catch (Exception e) {
            Log.debug((String)"windows", (String)e.getMessage());
        }
    }

    public KeyboardHandler getCustomKeyboardHandler(String subsystem) {
        NullCheck.notNull((Object)subsystem, (String)"subsystem");
        switch (subsystem.toLowerCase().trim()) {
            case "javafx": {
                return new KeyboardJavafxHandler();
            }
        }
        return null;
    }

    static interface ChannelBasicData {
        public String getType();
    }
}

