/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.extensions.emacspeak;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.luwrain.core.EmptyExtension;
import org.luwrain.core.ExtensionObject;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.extensions.emacspeak.Emacspeak;
import org.luwrain.speech.Channel;
import org.luwrain.speech.Engine;

public final class Extension
extends EmptyExtension {
    static final String LOG_COMPONENT = "emacspeak";

    public ExtensionObject[] getExtObjects(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        return new ExtensionObject[]{new Engine(){

            public String getExtObjName() {
                return Extension.LOG_COMPONENT;
            }

            public Set<Engine.Features> getFeatures() {
                return EnumSet.of(Engine.Features.CAN_SYNTH_TO_SPEAKERS);
            }

            public Channel newChannel(Map<String, String> params) {
                NullCheck.notNull(params, (String)"params");
                try {
                    return new Emacspeak(params);
                }
                catch (Exception e) {
                    Log.error((String)Extension.LOG_COMPONENT, (String)("unable to create a emacspeak channel:" + e.getClass().getName() + ":" + e.getMessage()));
                    return null;
                }
            }
        }};
    }
}

