/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux.lib;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.luwrain.core.ErrorJobInstance;
import org.luwrain.core.Job;
import org.luwrain.core.JobLauncher;
import org.luwrain.core.NullCheck;
import org.luwrain.linux.BashProcess;

@AutoService(value={JobLauncher.class})
public final class SysJob
implements JobLauncher {
    public Job launch(final Job.Listener listener, String[] args, String dir) {
        Objects.requireNonNull(listener, "listener can't be null");
        NullCheck.notNullItems((Object[])args, (String)"args");
        if (args.length == 0 || args[0].isEmpty()) {
            return new ErrorJobInstance("sys", "No command");
        }
        final Data data = new Data();
        final Job ins = new Job(){

            public void stop() {
                if (data.stopProc != null) {
                    data.stopProc.run();
                }
            }

            public String getInstanceName() {
                return data.cmd;
            }

            public Job.Status getStatus() {
                return data.finished ? Job.Status.FINISHED : Job.Status.RUNNING;
            }

            public int getExitCode() {
                return data.exitCode;
            }

            public boolean isFinishedSuccessfully() {
                return data.finished && data.exitCode == 0;
            }

            public List<String> getInfo(String type) {
                Objects.requireNonNull(type, "type can't be null");
                switch (type) {
                    case "brief": {
                        return Arrays.asList(data.state);
                    }
                    case "main": {
                        return data.mlState;
                    }
                }
                return Arrays.asList(new String[0]);
            }
        };
        data.cmd = SysJob.buildCmd(args);
        BashProcess p = new BashProcess(data.cmd, dir, EnumSet.noneOf(BashProcess.Flags.class), new BashProcess.Listener(){

            @Override
            public void onOutputLine(String line) {
                data.mlState.add(line);
                listener.onInfoChange(ins, "main", data.mlState);
            }

            @Override
            public void onErrorLine(String line) {
                data.mlState.add(line);
                listener.onInfoChange(ins, "main", data.mlState);
            }

            @Override
            public void onFinishing(int exitCode) {
                data.finished = true;
                data.exitCode = exitCode;
                listener.onStatusChange(ins);
            }
        });
        try {
            p.run();
        }
        catch (IOException e) {
            return new ErrorJobInstance(args[0], e.getMessage());
        }
        data.stopProc = () -> p.stop();
        return ins;
    }

    public String getExtObjName() {
        return "sys";
    }

    public Set<JobLauncher.Flags> getJobFlags() {
        return EnumSet.noneOf(JobLauncher.Flags.class);
    }

    private static String buildCmd(String[] args) {
        NullCheck.notNullItems((Object[])args, (String)"args");
        if (args.length == 0) {
            throw new IllegalArgumentException("args can't be empty");
        }
        if (args[0].isEmpty()) {
            throw new IllegalArgumentException("args[0] can't be empty");
        }
        return Arrays.asList(args).stream().collect(Collectors.joining(" "));
    }

    private static final class Data {
        String cmd;
        boolean finished = false;
        int exitCode = -1;
        String state = "";
        final List<String> mlState = new ArrayList<String>();
        Runnable stopProc = null;

        private Data() {
        }
    }
}

