/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ShellCmd {
    public final Process p;
    public final List<String> output = new ArrayList<String>();
    public final List<String> error = new ArrayList<String>();
    private final AtomicBoolean outputComplete = new AtomicBoolean(false);
    private final AtomicBoolean errorComplete = new AtomicBoolean(false);

    public ShellCmd(String cmd, String dir) {
        try {
            this.p = new ProcessBuilder("/bin/bash", "-c", cmd).directory(new File(dir)).start();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() {
        try {
            this.p.getOutputStream().close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        new Thread(() -> this.readStream(this.p.getInputStream(), this.output, this.outputComplete)).start();
        new Thread(() -> this.readStream(this.p.getErrorStream(), this.error, this.errorComplete)).start();
        try {
            this.p.waitFor();
            ShellCmd ex = this;
            synchronized (ex) {
                while (!this.outputComplete.get() || !this.errorComplete.get()) {
                    this.wait();
                }
            }
            return this.p.exitValue();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStream(InputStream s, List<String> lines, AtomicBoolean complete) {
        try {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(s, "UTF-8"));){
                String line = r.readLine();
                while (line != null) {
                    lines.add(line);
                    line = r.readLine();
                }
            }
            finally {
                s.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ShellCmd shellCmd = this;
        synchronized (shellCmd) {
            complete.set(true);
            this.notify();
        }
    }

    public static int execAndWait(String cmd, String dir) {
        return new ShellCmd(cmd, dir).waitFor();
    }
}

