/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.luwrain.app.parted.App;
import org.luwrain.core.Command;
import org.luwrain.core.DefaultShortcut;
import org.luwrain.core.EmptyExtension;
import org.luwrain.core.ExtensionObject;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.SimpleObjFactory;
import org.luwrain.core.SimpleShortcutCommand;
import org.luwrain.linux.DefaultDisksPopupFactory;
import org.luwrain.linux.FifoInputListening;
import org.luwrain.linux.Linux;
import org.luwrain.linux.PointerInputListening;
import org.luwrain.linux.TermInfo;
import org.luwrain.linux.script.Bindings;
import org.luwrain.linux.services.UdisksCliMonitor;
import org.luwrain.script.core.ScriptCore;

@AutoService(value={org.luwrain.core.Extension.class})
public final class Extension
extends EmptyExtension {
    private static final String LOG_COMPONENT = "linux";
    private static final String PREFIX_INPUT_POINTER = "--linux-input-pointer=";
    private static final String PREFIX_INPUT_FIFO = "--linux-input-fifo=";
    private static Linux linux = null;
    private ScriptCore scriptCore = null;
    private TermInfo termInfo = null;
    private UdisksCliMonitor udisksMonitor = null;
    private PointerInputListening[] pointerInputs = null;
    private FifoInputListening[] fifoInputs = null;

    public String init(Luwrain luwrain) {
        this.loadScriptCore(luwrain);
        try {
            this.termInfo = new TermInfo();
            this.termInfo.read();
        }
        catch (IOException e) {
            Log.error((String)LOG_COMPONENT, (String)("unable to load terminfo: " + e.getClass().getName() + ": " + e.getMessage()));
            this.termInfo = null;
        }
        try {
            this.udisksMonitor = new UdisksCliMonitor(luwrain);
        }
        catch (IOException e) {
            Log.info((String)LOG_COMPONENT, (String)"no udisks monitor service, the process can't be launched");
            this.udisksMonitor = null;
        }
        ArrayList inputs = new ArrayList();
        ArrayList fifos = new ArrayList();
        for (Object l : inputs) {
            ((PointerInputListening)l).run();
        }
        for (Object l : fifos) {
            ((FifoInputListening)l).run();
        }
        this.pointerInputs = inputs.toArray(new PointerInputListening[inputs.size()]);
        this.fifoInputs = fifos.toArray(new FifoInputListening[fifos.size()]);
        return null;
    }

    public void close() {
        if (this.udisksMonitor != null) {
            this.udisksMonitor.close();
        }
    }

    private void loadScriptCore(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.scriptCore = new ScriptCore(luwrain, (org.luwrain.script.core.Bindings)new Bindings(luwrain));
        File scriptsDir = luwrain.getFileProperty("luwrain.dir.js");
        if (scriptsDir == null || !scriptsDir.exists() || !scriptsDir.isDirectory()) {
            return;
        }
        File[] scripts = scriptsDir.listFiles();
        if (scripts == null) {
            return;
        }
        for (File f : scripts) {
            if (f == null || !f.getName().startsWith("linux-")) continue;
            Log.debug((String)LOG_COMPONENT, (String)("loading " + f.getAbsolutePath()));
            try {
                this.scriptCore.load(f);
            }
            catch (Throwable e) {
                Log.error((String)LOG_COMPONENT, (String)("unable to load " + f.getAbsolutePath() + ": " + e.getClass().getName() + ": " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public Command[] getCommands(Luwrain luwrain) {
        ArrayList<Object> res = new ArrayList<Object>();
        res.addAll(Arrays.asList(this.scriptCore.getCommands()));
        res.addAll(Arrays.asList(new SimpleShortcutCommand("term"), new SimpleShortcutCommand("parted"), new SimpleShortcutCommand("wifi"), new SimpleShortcutCommand("install")));
        return res.toArray(new Command[res.size()]);
    }

    public ExtensionObject[] getExtObjects(Luwrain luwrain) {
        ArrayList<Object> res = new ArrayList<Object>();
        res.add(new SimpleObjFactory("disks-popup-factory", "org.luwrain.linux.DefaultDisksPopupFactory", () -> new DefaultDisksPopupFactory(this.udisksMonitor)));
        res.add(new DefaultShortcut("parted", App.class));
        res.add(new DefaultShortcut("install", org.luwrain.app.install.App.class));
        res.add(new DefaultShortcut("wifi", org.luwrain.app.wifi.App.class));
        return res.toArray(new ExtensionObject[res.size()]);
    }

    static void setLinux(Linux newLinux) {
        if (newLinux == null) {
            throw new NullPointerException("newLinux may not be null");
        }
        if (linux != null) {
            throw new RuntimeException("linux object instance is already set");
        }
        linux = newLinux;
    }
}

