/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups.pim;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.pim.PimException;
import org.luwrain.pim.contacts.Contact;
import org.luwrain.pim.contacts.ContactValue;
import org.luwrain.pim.contacts.ContactsFolder;
import org.luwrain.pim.contacts.ContactsStoring;
import org.luwrain.popups.ListPopup2;
import org.luwrain.popups.Popups;
import org.luwrain.popups.pim.Strings;

public class ChooseMailPopup
extends ListPopup2 {
    protected final ContactsStoring storing;
    protected final Strings strings;

    public ChooseMailPopup(Luwrain luwrain, Strings strings, ContactsStoring storing, ContactsFolder folder) throws PimException {
        super(luwrain, ChooseMailPopup.createParams(luwrain, strings.chooseMailPopupName(folder.toString()), strings, storing, folder), Popups.DEFAULT_POPUP_FLAGS);
        NullCheck.notNull((Object)storing, (String)"storing");
        NullCheck.notNull((Object)strings, (String)"strings");
        this.storing = storing;
        this.strings = strings;
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ENTER: {
                    if (this.openSubfolder()) {
                        return true;
                    }
                    return super.onInputEvent(event);
                }
            }
        }
        return super.onInputEvent(event);
    }

    protected boolean openSubfolder() {
        Object sel = this.selected();
        if (sel == null) {
            return false;
        }
        if (sel instanceof Contact) {
            this.onContactEntry((Contact)sel);
            return true;
        }
        if (!(sel instanceof ContactsFolder)) {
            return false;
        }
        ContactsFolder folder = (ContactsFolder)sel;
        try {
            ChooseMailPopup popup = new ChooseMailPopup(this.luwrain, this.strings, this.storing, folder);
            this.luwrain.popup((Popup)popup);
            if (popup.closing.cancelled()) {
                return true;
            }
            this.result = popup.result();
            this.closing.doOk();
        }
        catch (PimException e) {
            this.luwrain.crash((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean onOk() {
        return this.result != null;
    }

    public String result() {
        return this.result.toString();
    }

    protected void onContactEntry(Contact contact) {
        try {
            LinkedList<String> addrs = new LinkedList<String>();
            ContactValue[] values = contact.getValues();
            if (values != null) {
                for (ContactValue v : values) {
                    if (v.getType() != ContactValue.Type.MAIL || v.getValue().trim().isEmpty()) continue;
                    addrs.add(v.getValue().trim());
                }
            }
            if (addrs.isEmpty()) {
                this.luwrain.message(this.strings.contactDoesntHaveMail(contact.getTitle()), Luwrain.MessageType.ERROR);
                return;
            }
            if (addrs.size() == 1) {
                this.result = contact.getTitle() + " <" + (String)addrs.getFirst() + ">";
                this.closing.doOk();
                return;
            }
            Object[] toOffer = addrs.toArray(new String[addrs.size()]);
            String r = (String)Popups.fixedList((Luwrain)this.luwrain, (String)this.strings.chooseMailForContactPopupName(contact.getTitle()), (Object[])toOffer);
            if (r == null) {
                return;
            }
            this.result = contact.getTitle() + " <" + r + ">";
            this.closing.doOk();
            return;
        }
        catch (Exception e) {
            this.luwrain.crash((Throwable)e);
            return;
        }
    }

    protected static ListArea.Params<Object> createParams(Luwrain luwrain, String name, Strings strings, ContactsStoring storing, ContactsFolder folder) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)strings, (String)"strings");
        NullCheck.notNull((Object)storing, (String)"storing");
        NullCheck.notNull((Object)folder, (String)"folder");
        ListArea.Params params = new ListArea.Params();
        params.context = new DefaultControlContext(luwrain);
        params.name = name;
        params.model = new Model(storing, folder);
        params.appearance = new Appearance(luwrain, strings);
        return params;
    }

    protected static class Model
    implements ListArea.Model<Object> {
        protected final ContactsStoring storing;
        protected final ContactsFolder folder;
        protected Object[] items;

        Model(ContactsStoring storing, ContactsFolder folder) {
            NullCheck.notNull((Object)storing, (String)"storing");
            NullCheck.notNull((Object)folder, (String)"folder");
            this.storing = storing;
            this.folder = folder;
            this.refresh();
        }

        public int getItemCount() {
            return this.items != null ? this.items.length : 0;
        }

        public Object getItem(int index) {
            return this.items != null && index < this.items.length ? this.items[index] : null;
        }

        public void refresh() {
            try {
                ContactsFolder[] folders = this.storing.getFolders().load(this.folder);
                Contact[] contacts = this.storing.getContacts().load(this.folder);
                ArrayList<Object> res = new ArrayList<Object>();
                for (ContactsFolder f : folders) {
                    res.add(f);
                }
                for (Contact c : contacts) {
                    res.add(c);
                }
                this.items = res.toArray(new Object[res.size()]);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.items = new Object[0];
            }
        }
    }

    protected static class Appearance
    extends ListUtils.AbstractAppearance<Object> {
        protected final Luwrain luwrain;
        protected final Strings strings;

        Appearance(Luwrain luwrain, Strings strings) {
            NullCheck.notNull((Object)luwrain, (String)"luwrain");
            NullCheck.notNull((Object)strings, (String)"strings");
            this.luwrain = luwrain;
            this.strings = strings;
        }

        public void announceItem(Object item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            this.luwrain.playSound(Sounds.LIST_ITEM);
            if (item instanceof ContactsFolder) {
                ContactsFolder folder = (ContactsFolder)item;
                try {
                    String title = folder.getTitle();
                    this.luwrain.speak(title + " \u0433\u0440\u0443\u043f\u043f\u0430");
                    return;
                }
                catch (Exception e) {
                    this.luwrain.crash((Throwable)e);
                    return;
                }
            }
            this.luwrain.speak(item.toString());
        }
    }
}

