/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.news.persist;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.h2.mvstore.MVMap;
import org.luwrain.pim.ExecQueues;
import org.luwrain.pim.news.persist.Article;
import org.luwrain.pim.news.persist.ArticleDAO;
import org.luwrain.pim.news.persist.Group;
import org.luwrain.pim.news.persist.GroupDAO;

public final class NewsPersistence {
    private static final Logger log = LogManager.getLogger();
    final ExecQueues queues;
    private ExecQueues.Priority priority = ExecQueues.Priority.MEDIUM;
    private ExecQueues.Runner runner;
    private final MVMap<Integer, Group> groupsMap;
    private final MVMap<Long, Article> articlesMap;
    private final MVMap<String, Long> keysMap;

    public NewsPersistence(ExecQueues queues, MVMap<Integer, Group> groupsMap, MVMap<Long, Article> articlesMap, MVMap<String, Long> keysMap) {
        this.queues = Objects.requireNonNull(queues, "queues can't be null");
        this.groupsMap = Objects.requireNonNull(groupsMap, "groupsMap can't be null");
        this.articlesMap = Objects.requireNonNull(articlesMap, "articlesMap can't be null");
        this.keysMap = Objects.requireNonNull(keysMap, "keysMap can't be null");
        this.runner = new ExecQueues.Runner(queues, this.priority);
    }

    public GroupDAO getGroupDAO() {
        return new GroupDAO(){

            @Override
            public List<Group> load() {
                return NewsPersistence.this.runner.run(() -> NewsPersistence.this.groupsMap.entrySet().stream().map(e -> (Group)e.getValue()).toList());
            }

            @Override
            public int add(Group group) {
                Objects.requireNonNull(group, "group can't be null");
                return NewsPersistence.this.runner.run(() -> {
                    int newId = NewsPersistence.this.getNewKey(Group.class).intValue();
                    group.setId(newId);
                    log.trace("Adding " + String.valueOf(group));
                    NewsPersistence.this.groupsMap.put((Object)newId, (Object)group);
                    return newId;
                });
            }

            @Override
            public void delete(Group group) {
                Objects.requireNonNull(group, "group can't be null");
                if (group.getId() < 0) {
                    throw new IllegalArgumentException("A group can't have negative ID");
                }
                log.trace("Removing " + String.valueOf(group));
                NewsPersistence.this.runner.run(new FutureTask<Object>(() -> NewsPersistence.this.groupsMap.remove((Object)group.getId()), null));
            }

            @Override
            public void update(Group group) {
                Objects.requireNonNull(group, "group can't be null");
                if (group.getId() < 0) {
                    throw new IllegalArgumentException("A group can't have negative ID");
                }
                log.trace("Updating " + String.valueOf(group));
                NewsPersistence.this.runner.run(new FutureTask<Object>(() -> NewsPersistence.this.groupsMap.put((Object)group.getId(), (Object)group), null));
            }
        };
    }

    public ArticleDAO getArticleDAO() {
        return new ArticleDAO(){

            @Override
            public List<Article> load(Group group) {
                Objects.requireNonNull(group, "group");
                return NewsPersistence.this.runner.run(() -> NewsPersistence.this.articlesMap.entrySet().stream().filter(e -> ((Article)e.getValue()).getGroupId() == group.getId()).map(e -> (Article)e.getValue()).toList());
            }

            @Override
            public List<Article> load(Group group, Predicate<Article> filter) {
                Objects.requireNonNull(group, "group");
                if (filter == null) {
                    return this.load(group);
                }
                return NewsPersistence.this.runner.run(() -> NewsPersistence.this.articlesMap.entrySet().stream().filter(e -> ((Article)e.getValue()).getGroupId() == group.getId()).filter(e -> filter.test((Article)e.getValue())).map(e -> (Article)e.getValue()).toList());
            }

            @Override
            public void update(Article article) {
                Objects.requireNonNull(article, "article can't be null");
                if (article.getId() < 0L) {
                    throw new IllegalArgumentException("An article can't have negative ID");
                }
                log.trace("Updating " + String.valueOf(article));
                NewsPersistence.this.runner.run(new FutureTask<Object>(() -> NewsPersistence.this.articlesMap.put((Object)article.getId(), (Object)article), null));
            }

            @Override
            public long add(Group group, Article article) {
                Objects.requireNonNull(group, "group can't be null");
                Objects.requireNonNull(article, "article");
                return NewsPersistence.this.runner.run(() -> {
                    long newId = NewsPersistence.this.getNewKey(Article.class).intValue();
                    article.setId(newId);
                    article.setGroupId(group.getId());
                    NewsPersistence.this.articlesMap.put((Object)newId, (Object)article);
                    return newId;
                }).intValue();
            }

            @Override
            public void delete(Group group, Article article) {
                Objects.requireNonNull(article, "article can't be null");
                if (article.getId() < 0L) {
                    throw new IllegalArgumentException("An article can't have negative ID");
                }
                log.trace("Removing " + String.valueOf(article));
                NewsPersistence.this.runner.run(new FutureTask<Object>(() -> NewsPersistence.this.articlesMap.remove((Object)article.getId()), null));
            }

            @Override
            public Set<String> loadUrisInGroup(Group group) {
                return new HashSet<String>(NewsPersistence.this.runner.run(() -> NewsPersistence.this.articlesMap.entrySet().parallelStream().map(e -> ((Article)e.getValue()).getUri()).toList()));
            }

            @Override
            public List<Integer> countMarkedInGroups(List<Group> groups) {
                return null;
            }

            @Override
            public List<Integer> countNewInGroups(List<Group> groups) {
                return null;
            }

            @Override
            public int countNewInGroup(Group group) {
                return 0;
            }

            @Override
            public int countByUriInGroup(Group group, String uri) {
                return 0;
            }
        };
    }

    Long getNewKey(Class c) {
        Long res = (Long)this.keysMap.get((Object)c.getName());
        if (res == null) {
            this.keysMap.put((Object)c.getName(), (Object)0L);
            return 0L;
        }
        Long newVal = res + 1L;
        this.keysMap.put((Object)c.getName(), (Object)newVal);
        return newVal;
    }

    public void setPriority(ExecQueues.Priority priority) {
        this.priority = Objects.requireNonNull(priority, "priority can't be null");
        this.runner = new ExecQueues.Runner(this.queues, priority);
    }
}

