/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.news;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.luwrain.pim.ExecQueues;
import org.luwrain.pim.news.persist.Article;
import org.luwrain.pim.news.persist.Group;
import org.luwrain.pim.news.persist.NewsPersistence;

public final class NewsFactory
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger();
    final Path path;
    final ExecQueues queues = new ExecQueues();
    private final MVStore store;
    private final MVMap<Integer, Group> groupsMap;
    private final MVMap<Long, Article> articlesMap;
    private final MVMap<String, Long> keysMap;

    public NewsFactory(Path path) throws IOException {
        this.path = Objects.requireNonNull(path, "path can't be null");
        Files.createDirectories(path, new FileAttribute[0]);
        String dbFile = path.resolve("news.mvdb").toString();
        log.trace("Opening the news database in " + dbFile);
        this.store = MVStore.open((String)dbFile);
        this.articlesMap = this.store.openMap("articles");
        this.groupsMap = this.store.openMap("groups");
        this.keysMap = this.store.openMap("keys");
    }

    public Object newInstance() {
        return new NewsPersistence(this.queues, this.groupsMap, this.articlesMap, this.keysMap);
    }

    @Override
    public void close() {
        this.queues.close();
        this.store.close();
        log.trace("The news database closed");
    }
}

