/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail.persistence;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.FutureTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.h2.mvstore.MVMap;
import org.luwrain.pim.ExecQueues;
import org.luwrain.pim.mail.persistence.Account;
import org.luwrain.pim.mail.persistence.AccountDAO;
import org.luwrain.pim.mail.persistence.Folder;
import org.luwrain.pim.mail.persistence.FolderDAO;
import org.luwrain.pim.mail.persistence.MessageDAO;
import org.luwrain.pim.mail.persistence.MessageMetadata;

public final class MailPersistence {
    private static final Logger log = LogManager.getLogger();
    final ExecQueues queues;
    private ExecQueues.Priority priority = ExecQueues.Priority.MEDIUM;
    private ExecQueues.Runner runner = null;
    private final MVMap<Integer, Account> accountsMap;
    private final MVMap<Integer, Folder> foldersMap;
    private final MVMap<Long, MessageMetadata> messagesMap;
    private final MVMap<String, Long> keysMap;

    public MailPersistence(ExecQueues queues, MVMap<Integer, Account> accountsMap, MVMap<Integer, Folder> foldersMap, MVMap<Long, MessageMetadata> messagesMap, MVMap<String, Long> keysMap) {
        this.queues = Objects.requireNonNull(queues, "queues can't be null");
        this.accountsMap = Objects.requireNonNull(accountsMap, "accountsMap can't be null");
        this.foldersMap = Objects.requireNonNull(foldersMap, "foldersMap can't be null");
        this.messagesMap = Objects.requireNonNull(messagesMap, "messagesMap can't be null");
        this.keysMap = Objects.requireNonNull(keysMap, "keysMap can't be null");
        this.runner = new ExecQueues.Runner(queues, this.priority);
    }

    public AccountDAO getAccountDAO() {
        return new AccountDAO(){

            @Override
            public Account getById(int id) {
                if (id < 0) {
                    throw new IllegalArgumentException("id can't be negative");
                }
                return MailPersistence.this.runner.run(() -> (Account)MailPersistence.this.accountsMap.get((Object)id));
            }

            @Override
            public void delete(Account account) {
                Objects.requireNonNull(account, "account can't be null");
                if (account.getId() < 0) {
                    throw new IllegalArgumentException("An account can't have negative ID");
                }
                log.trace("Deleting " + String.valueOf(account));
                MailPersistence.this.runner.run(new FutureTask<Account>(() -> (Account)MailPersistence.this.accountsMap.remove((Object)account.getId())));
            }

            @Override
            public int add(Account account) {
                Objects.requireNonNull(account, "account can't be null");
                return MailPersistence.this.runner.run(() -> {
                    int newId = MailPersistence.this.getNewKey(Account.class).intValue();
                    account.setId(newId);
                    log.trace("Adding " + String.valueOf(account));
                    MailPersistence.this.accountsMap.put((Object)newId, (Object)account);
                    return newId;
                });
            }

            @Override
            public List<Account> getAll() {
                return MailPersistence.this.runner.run(() -> MailPersistence.this.accountsMap.entrySet().stream().map(e -> (Account)e.getValue()).toList());
            }

            @Override
            public void update(Account account) {
                Objects.requireNonNull(account, "account can't be null");
                if (account.getId() < 0) {
                    throw new IllegalArgumentException("An account can't have negative ID");
                }
                log.trace("Updating " + String.valueOf(account));
                MailPersistence.this.runner.run(new FutureTask<Object>(() -> MailPersistence.this.accountsMap.put((Object)account.getId(), (Object)account), null));
            }
        };
    }

    public FolderDAO getFolderDAO() {
        return new FolderDAO(){

            @Override
            public int add(Folder folder) {
                Objects.requireNonNull(folder, "folder can't be null");
                return MailPersistence.this.runner.run(new FutureTask<Integer>(() -> {
                    int newId = MailPersistence.this.getNewKey(Folder.class).intValue();
                    folder.setId(newId);
                    MailPersistence.this.foldersMap.put((Object)newId, (Object)folder);
                    return newId;
                }));
            }

            @Override
            public List<Folder> getAll() {
                return MailPersistence.this.runner.run(new FutureTask<List>(() -> MailPersistence.this.foldersMap.entrySet().stream().map(e -> (Folder)e.getValue()).toList()));
            }

            @Override
            public List<Folder> getChildFolders(Folder folder) {
                Objects.requireNonNull(folder, "folder can't be null");
                if (folder.getId() < 0) {
                    throw new IllegalArgumentException("A folder can't have negative ID");
                }
                int id = folder.getId();
                return MailPersistence.this.runner.run(new FutureTask<List>(() -> MailPersistence.this.foldersMap.entrySet().stream().filter(e -> ((Folder)e.getValue()).getParentFolderId() == id).map(e -> (Folder)e.getValue()).toList()));
            }

            @Override
            public Folder findFirstByProperty(String propName, String propValue) {
                Objects.requireNonNull(propName, "propName can't be null");
                Objects.requireNonNull(propValue, "propValue can't be null");
                if (propName.isEmpty()) {
                    throw new IllegalArgumentException("propName can't be empty");
                }
                return MailPersistence.this.runner.run(new FutureTask<Folder>(() -> {
                    Optional<Folder> res = MailPersistence.this.foldersMap.entrySet().stream().filter(e -> ((Folder)e.getValue()).getProperties().getProperty(propName).equals(propValue)).map(e -> (Folder)e.getValue()).findFirst();
                    return res.isPresent() ? res.get() : null;
                }));
            }

            @Override
            public void update(Folder folder) {
                Objects.requireNonNull(folder, "folder can't be null");
                if (folder.getId() < 0) {
                    throw new IllegalArgumentException("A folder can't have negative ID");
                }
                MailPersistence.this.runner.run(new FutureTask<Object>(() -> MailPersistence.this.foldersMap.put((Object)folder.getId(), (Object)folder), null));
            }

            @Override
            public Folder getRoot() {
                return MailPersistence.this.runner.run(new FutureTask<Folder>(() -> {
                    Optional<Folder> res = MailPersistence.this.foldersMap.entrySet().stream().filter(e -> ((Folder)e.getValue()).getParentFolderId() == ((Folder)e.getValue()).getId()).map(e -> (Folder)e.getValue()).findFirst();
                    return res.isPresent() ? res.get() : null;
                }));
            }
        };
    }

    public MessageDAO getMessageDAO() {
        return new MessageDAO(){

            @Override
            public long add(MessageMetadata message) {
                Objects.requireNonNull(message, "message can't be null");
                return MailPersistence.this.runner.run(new FutureTask<Long>(() -> {
                    Long maxKey = (Long)MailPersistence.this.messagesMap.floorKey((Object)Long.MAX_VALUE);
                    long newId = maxKey + 1L;
                    message.setId(newId);
                    MailPersistence.this.messagesMap.put((Object)newId, (Object)message);
                    return newId;
                }));
            }

            @Override
            public void delete(MessageMetadata message) {
                Objects.requireNonNull(message, "message can't be null");
                if (message.getId() < 0L) {
                    throw new IllegalArgumentException("A message can't has negative ID");
                }
                MailPersistence.this.runner.run(new FutureTask<MessageMetadata>(() -> (MessageMetadata)MailPersistence.this.messagesMap.remove((Object)message.getId())));
            }

            @Override
            public List<MessageMetadata> getAll() {
                return MailPersistence.this.runner.run(new FutureTask<List>(() -> MailPersistence.this.messagesMap.entrySet().stream().map(e -> (MessageMetadata)e.getValue()).toList()));
            }

            @Override
            public List<MessageMetadata> getByFolderId(int folderId) {
                return MailPersistence.this.runner.run(new FutureTask<List>(() -> MailPersistence.this.messagesMap.entrySet().stream().filter(e -> ((MessageMetadata)e.getValue()).getFolderId() == folderId).map(e -> (MessageMetadata)e.getValue()).toList()));
            }

            @Override
            public void update(MessageMetadata message) {
                Objects.requireNonNull(message, "message can't be null");
                if (message.getId() < 0L) {
                    throw new IllegalArgumentException("A message can't have negative ID");
                }
                MailPersistence.this.runner.run(new FutureTask<Object>(() -> MailPersistence.this.messagesMap.put((Object)message.getId(), (Object)message), null));
            }
        };
    }

    public void deleteAllFolders() {
        this.runner.run(new FutureTask<Object>(() -> this.foldersMap.clear(), null));
    }

    void deleteAllAccounts() {
    }

    Long getNewKey(Class c) {
        Long res = (Long)this.keysMap.get((Object)c.getName());
        if (res == null) {
            this.keysMap.put((Object)c.getName(), (Object)0L);
            return 0L;
        }
        Long newVal = res + 1L;
        this.keysMap.put((Object)c.getName(), (Object)newVal);
        return newVal;
    }

    public void setPriority(ExecQueues.Priority priority) {
        this.priority = Objects.requireNonNull(priority, "priority can't be null");
        this.runner = new ExecQueues.Runner(this.queues, priority);
    }
}

