/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.pim.PimException;
import org.luwrain.pim.mail.Message;
import org.luwrain.pim.mail.MessageConsumer;
import org.luwrain.pim.mail.MessageContentItem;
import org.luwrain.pim.mail.MimePartsExtractor;
import org.luwrain.pim.mail.persistence.MessageMetadata;

public final class MessageDecoder
implements MessageConsumer {
    private static final Logger log = LogManager.getLogger();

    @Override
    public void onMessage(Message message) {
        Session session = Session.getDefaultInstance((Properties)new Properties(), null);
        MessageMetadata m = message.metadata = new MessageMetadata();
        try {
            MimeMessage mm;
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(message.rawMessage);){
                mm = new MimeMessage(session, (InputStream)byteStream);
            }
            m.setSubject(mm.getSubject());
            if (mm.getFrom() != null) {
                m.setFromAddr(MimeUtility.decodeText((String)mm.getFrom()[0].toString()));
            }
            if (mm.getRecipients(Message.RecipientType.TO) != null) {
                m.setToAddr(MessageDecoder.decodeAddrs(mm.getRecipients(Message.RecipientType.TO)));
            }
            m.setSentTimestamp(mm.getSentDate().getTime());
            log.trace("Decoding message body");
            MimePartsExtractor e = new MimePartsExtractor();
            e.on((MimePart)mm);
            m.setContent(MessageContentItem.toJson(e.items));
        }
        catch (Exception ex) {
            log.catching((Throwable)ex);
            throw new PimException(ex);
        }
    }

    private static List<String> decodeAddrs(Address[] addrs) throws IOException {
        if (addrs == null) {
            return Arrays.asList(new String[0]);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < addrs.length; ++i) {
            if (addrs[i] == null) continue;
            res.add(MimeUtility.decodeText((String)addrs[i].toString()));
        }
        return res;
    }
}

