/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.fetching;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.PimException;
import org.luwrain.pim.news.persist.Article;
import org.luwrain.util.Connections;
import org.luwrain.util.MlTagStrip;

public final class FeedUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Article> readFeed(URL url) throws PimException, InterruptedException {
        NullCheck.notNull((Object)url, (String)"url");
        ArrayList<Article> articles = new ArrayList<Article>();
        XmlReader reader = null;
        try {
            URLConnection con = null;
            InputStream is = null;
            try {
                con = Connections.connect((URI)url.toURI(), (long)0L);
                is = con.getInputStream();
                reader = new XmlReader(is);
                SyndFeed feed = new SyndFeedInput().build((Reader)reader);
                Iterator i = feed.getEntries().iterator();
                while (i.hasNext()) {
                    List contents;
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    SyndEntry entry = (SyndEntry)i.next();
                    Article article = new Article();
                    if (feed.getTitle() != null) {
                        article.setSourceTitle(MlTagStrip.run((String)feed.getTitle()));
                    }
                    if (entry.getTitle() != null) {
                        article.setTitle(entry.getTitle().replaceAll("\u00a0", " "));
                    }
                    if (entry.getUri() != null) {
                        article.setUri(entry.getUri());
                    }
                    if (entry.getLink() != null) {
                        article.setUrl(entry.getLink());
                    }
                    if (entry.getPublishedDate() != null) {
                        article.setPublishedTimestamp(entry.getPublishedDate().getTime());
                    }
                    if (entry.getUpdatedDate() != null) {
                        article.setUpdatedTimestamp(entry.getUpdatedDate().getTime());
                    }
                    if (entry.getAuthor() != null) {
                        article.setAuthor(entry.getAuthor());
                    }
                    if (article.getUri() == null || article.getUri().isEmpty()) {
                        article.setUri(article.getUrl());
                    }
                    if ((contents = entry.getContents()) != null) {
                        if (contents.size() > 0) {
                            for (Object o : contents) {
                                SyndContentImpl content;
                                if (o == null || !(o instanceof SyndContentImpl) || (content = (SyndContentImpl)o).getValue() == null) continue;
                                article.setContent(article.getContent() + content.getValue());
                            }
                        } else {
                            SyndContent content = entry.getDescription();
                            if (content != null) {
                                article.setContent(content.getValue());
                            }
                        }
                    }
                    articles.add(article);
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (FeedException | IOException | URISyntaxException e) {
            throw new PimException(e);
        }
        return articles;
    }
}

