/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.ObjFactory;
import org.luwrain.pim.mail.MailFactory;
import org.luwrain.pim.mail.persistence.MailPersistence;
import org.luwrain.pim.news.NewsFactory;
import org.luwrain.pim.news.persist.NewsPersistence;

public final class PimObjFactory
implements ObjFactory,
AutoCloseable {
    private static final Logger log = LogManager.getLogger();
    private final Path baseDir;
    private NewsFactory newsFactory = null;
    private MailFactory mailFactory = null;

    PimObjFactory(Path baseDir) {
        this.baseDir = Objects.requireNonNull(baseDir, "baseDir can't be null");
    }

    public String getExtObjName() {
        return "luwrain.pim.factory";
    }

    public Object newObject(String name) {
        Objects.requireNonNull(name, "name can't be null");
        try {
            if (name.equals(NewsPersistence.class.getName())) {
                if (this.newsFactory == null) {
                    this.newsFactory = new NewsFactory(this.baseDir.resolve("news"));
                }
                return this.newsFactory.newInstance();
            }
            if (name.equals(MailPersistence.class.getName())) {
                if (this.mailFactory == null) {
                    this.mailFactory = new MailFactory(this.baseDir.resolve("mail"));
                }
                return this.mailFactory.newInstance();
            }
            return null;
        }
        catch (IOException ex) {
            log.error("Unable to create an object " + name, (Throwable)ex);
            return null;
        }
    }

    @Override
    public void close() {
        if (this.newsFactory != null) {
            this.newsFactory.close();
        }
        this.newsFactory = null;
    }
}

