/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.luwrain.pim.PimException;

public final class ExecQueues
implements Runnable,
AutoCloseable {
    private final ConcurrentLinkedQueue<FutureTask> mediumPriorityQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<FutureTask> highPriorityQueue = new ConcurrentLinkedQueue();
    private final Object syncObj = new Object();
    private final Object finishedObj = new Object();
    private final Thread thread = new Thread(this);
    private volatile boolean cancelling = false;
    private volatile boolean finished = false;

    public ExecQueues() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T exec(Priority priority, FutureTask<T> task) throws Exception {
        Objects.requireNonNull(priority, "priority");
        Objects.requireNonNull(task, "task can't be null");
        Object object = this.syncObj;
        synchronized (object) {
            switch (priority) {
                case MEDIUM: {
                    this.mediumPriorityQueue.add(task);
                    break;
                }
                case HIGH: {
                    this.highPriorityQueue.add(task);
                }
            }
            this.syncObj.notifyAll();
        }
        try {
            return task.get();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof Exception) {
                Exception ex = (Exception)throwable;
                throw ex;
            }
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.syncObj;
        synchronized (object) {
            this.cancelling = true;
            this.syncObj.notifyAll();
        }
        object = this.finishedObj;
        synchronized (object) {
            while (!this.finished) {
                try {
                    this.finishedObj.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        block8: while (true) {
            object = this.syncObj;
            synchronized (object) {
                try {
                    while (this.highPriorityQueue.isEmpty() && this.mediumPriorityQueue.isEmpty() && !this.cancelling) {
                        this.syncObj.wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.cancelling) break;
            while (true) {
                FutureTask task;
                if (this.highPriorityQueue.isEmpty() && this.mediumPriorityQueue.isEmpty()) continue block8;
                if (this.cancelling) {
                    return;
                }
                while (!this.highPriorityQueue.isEmpty()) {
                    task = this.highPriorityQueue.poll();
                    task.run();
                }
                if (this.mediumPriorityQueue.isEmpty()) continue;
                task = this.mediumPriorityQueue.poll();
                task.run();
            }
            break;
        }
        object = this.finishedObj;
        synchronized (object) {
            this.finished = true;
            this.finishedObj.notifyAll();
        }
    }

    public static enum Priority {
        HIGH,
        MEDIUM;

    }

    public static final class Runner {
        final ExecQueues queues;
        final Priority priority;

        public Runner(ExecQueues queues, Priority priority) {
            this.queues = Objects.requireNonNull(queues, "queues can't be null");
            this.priority = Objects.requireNonNull(priority, "[priority can't be null");
        }

        public <T> T run(Callable<T> task) {
            Objects.requireNonNull(task, "task");
            return this.run(new FutureTask<T>(task));
        }

        public <T> T run(FutureTask<T> task) {
            Objects.requireNonNull(task, "task can't be null");
            try {
                return this.queues.exec(this.priority, task);
            }
            catch (Exception ex) {
                throw new PimException(ex);
            }
        }
    }
}

