/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.inlandes.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import org.luwrain.inlandes.Token;
import org.luwrain.inlandes.util.AbstractTokenizer;

public final class Tokenizer
extends AbstractTokenizer {
    private final LinkedList<Character> qu = new LinkedList();
    private final Reader reader;

    public Tokenizer(Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader may not be null");
        }
        this.reader = reader;
    }

    @Override
    public char getCh() {
        if (this.qu.isEmpty()) {
            throw new RuntimeException("Trying to get a char with the empty queue");
        }
        Character ch = this.qu.pollFirst();
        return ch.charValue();
    }

    @Override
    public boolean hasCh() {
        int ch;
        if (!this.qu.isEmpty()) {
            return true;
        }
        try {
            ch = this.reader.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (ch < 0) {
            return false;
        }
        this.qu.add(Character.valueOf((char)ch));
        return true;
    }

    @Override
    public void backCh(char ch) {
        this.qu.addFirst(Character.valueOf(ch));
    }

    public static Token[] tokenize(String text) {
        if (text == null) {
            throw new NullPointerException("text may not be null");
        }
        Tokenizer t = new Tokenizer(new StringReader(text));
        t.tokenize();
        return t.getOutput();
    }
}

