/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.inlandes;

import java.util.List;
import org.luwrain.inlandes.Ref;
import org.luwrain.inlandes.Token;

public final class WhereStatement {
    final Item[] items;

    WhereStatement(List<Item> items) {
        this.items = items.toArray(new Item[items.size()]);
    }

    public static interface Item {
        public Ref getRef();

        public boolean isOptional();
    }

    public static final class Fixed
    implements Item {
        final Matcher matcher;
        final String hint;
        final Ref ref;
        final boolean optional;

        Fixed(Matcher matcher, String hint, Ref ref, boolean optional) {
            if (matcher == null) {
                throw new NullPointerException("matcher can't be null");
            }
            this.matcher = matcher;
            this.hint = hint != null ? hint : "";
            this.ref = ref;
            this.optional = optional;
        }

        @Override
        public Ref getRef() {
            return this.ref;
        }

        public String toString() {
            return this.hint;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }
    }

    public static final class Alternative
    implements Item {
        final Item[] items;
        final Ref ref;
        final boolean optional;

        Alternative(List<Item> items, Ref ref, boolean optional) {
            this.items = items.toArray(new Item[items.size()]);
            this.ref = ref;
            this.optional = optional;
        }

        @Override
        public Ref getRef() {
            return this.ref;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }
    }

    public static final class Block
    implements Item {
        final Item[] items;
        final Ref ref;
        final boolean optional;

        Block(List<Item> items, Ref ref, boolean optional) {
            this.items = items.toArray(new Item[items.size()]);
            this.ref = ref;
            this.optional = optional;
        }

        @Override
        public Ref getRef() {
            return this.ref;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }
    }

    public static interface Matcher {
        public boolean match(Token var1);
    }
}

