/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.luwrain.app.player.TrackInfo;
import org.luwrain.player.Playlist;
import org.luwrain.util.Urls;

class Utils {
    Utils() {
    }

    static String getTrackTextAppearanceWithMap(String trackUrl, Map<String, TrackInfo> map) {
        String tagText = Utils.getTrackTagText(trackUrl, map);
        if (tagText != null) {
            return tagText;
        }
        String name = "";
        try {
            File f = Urls.toFile((URL)new URL(trackUrl));
            name = f == null ? trackUrl : f.getName();
        }
        catch (MalformedURLException e) {
            name = trackUrl;
        }
        return name;
    }

    private static String getTrackTagText(String trackUrl, Map<String, TrackInfo> map) {
        if (!map.containsKey(trackUrl)) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        TrackInfo info = map.get(trackUrl);
        if (info == null) {
            return null;
        }
        if (info.artist.trim().isEmpty() && info.title.trim().isEmpty()) {
            return null;
        }
        if (!info.artist.trim().isEmpty()) {
            b.append(info.artist.trim());
        }
        if (!info.artist.trim().isEmpty() && !info.title.trim().isEmpty()) {
            b.append(" - ");
        }
        if (!info.title.trim().isEmpty()) {
            b.append(info.title);
        }
        return new String(b);
    }

    static String getTimeStr(long sec) {
        StringBuilder b = new StringBuilder();
        long min = sec / 60L;
        long seconds = sec % 60L;
        if (min < 10L) {
            b.append("0" + min);
        } else {
            b.append("" + min);
        }
        b.append(":");
        if (seconds < 10L) {
            b.append("0" + seconds);
        } else {
            b.append("" + seconds);
        }
        return new String(b);
    }

    static boolean isStreamingPlaylist(Playlist playlist) {
        return false;
    }
}

