/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import org.luwrain.app.player.App;
import org.luwrain.app.player.Strings;
import org.luwrain.app.player.Utils;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.NavigationArea;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;

class ControlArea
extends NavigationArea {
    private final App app;
    private final Strings strings;
    private Mode mode = Mode.STOPPED;
    private String playlistTitle = "";
    private String trackTitle = "";
    private long timeSec = 0L;
    private String[] content = new String[]{""};

    ControlArea(App app, ControlContext controlContext, Strings strings) {
        super(controlContext);
        this.app = app;
        this.strings = strings;
    }

    public boolean onInputEvent(InputEvent event) {
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ARROW_LEFT: {
                    return this.app.getPlayer().jump(-5000L);
                }
                case ALTERNATIVE_ARROW_LEFT: {
                    if (!this.app.getPlayer().jump(-5000L)) {
                        return false;
                    }
                    this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.OK, (String)Utils.getTimeStr(this.timeSec)));
                    return true;
                }
                case ARROW_RIGHT: {
                    return this.app.getPlayer().jump(5000L);
                }
                case ALTERNATIVE_ARROW_RIGHT: {
                    if (!this.app.getPlayer().jump(5000L)) {
                        return false;
                    }
                    this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.OK, (String)Utils.getTimeStr(this.timeSec)));
                    return true;
                }
                case ARROW_UP: {
                    return this.app.getPlayer().prevTrack();
                }
                case ARROW_DOWN: {
                    return this.app.getPlayer().nextTrack();
                }
            }
        }
        return super.onInputEvent(event);
    }

    void setMode(Mode mode) {
        NullCheck.notNull((Object)((Object)mode), (String)"mode");
        this.mode = mode;
        this.updateText();
    }

    void setPlaylistTitle(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        this.playlistTitle = value;
        this.updateText();
    }

    void setTrackTitle(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        this.trackTitle = value;
        this.updateText();
    }

    void setTrackTime(long msec) {
        if (msec < 0L) {
            throw new IllegalArgumentException("msec (" + msec + ") may not be negative");
        }
        long sec = msec / 1000L;
        if (sec != this.timeSec) {
            this.timeSec = sec;
            this.updateText();
        }
    }

    public int getLineCount() {
        return this.content.length;
    }

    public String getLine(int index) {
        if (index < 0) {
            return "";
        }
        return this.content[index];
    }

    public String getAreaName() {
        return this.strings.controlAreaName();
    }

    private void updateText() {
        switch (this.mode) {
            case STOPPED: {
                this.content = new String[]{""};
                break;
            }
            case PLAYING: 
            case PAUSED: {
                this.content = new String[]{this.playlistTitle, this.trackTitle, Utils.getTimeStr(this.timeSec), ""};
                break;
            }
            case PLAYING_STREAMING: {
                this.content = new String[]{this.playlistTitle, ""};
            }
        }
        this.setHotPoint(0, this.content.length - 1);
        this.redraw();
    }

    static enum Mode {
        STOPPED,
        PAUSED,
        PLAYING,
        PLAYING_STREAMING;

    }
}

