/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.player.Album;
import org.luwrain.app.player.App;
import org.luwrain.controls.EditableListArea;

public final class Albums
extends ArrayList<Album>
implements EditableListArea.Model<Album> {
    private static final Logger log = LogManager.getLogger();
    private final App app;

    Albums(App app) {
        this.app = app;
        this.load();
    }

    private synchronized void load() {
        this.clear();
        if (this.app.conf.albums == null) {
            return;
        }
        this.addAll(this.app.conf.albums);
    }

    synchronized void save() {
        this.app.conf.albums = new ArrayList<Album>();
        this.app.conf.albums.addAll(this);
        this.app.getLuwrain().saveConf((Object)this.app.conf);
    }

    synchronized int addAlbum(int pos, Album album) {
        if (pos < 0 || pos >= this.size()) {
            this.add(album);
            this.save();
            return this.size() - 1;
        }
        this.add(pos, album);
        this.save();
        return pos;
    }

    synchronized void deleteAlbum(int index) throws IOException {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("index (" + String.valueOf(index) + ") must be non-negative and less than " + String.valueOf(this.size()));
        }
        this.remove(index);
        this.save();
    }

    public synchronized boolean addToModel(int pos, Supplier<Object> supplier) {
        Object supplied = supplier.get();
        if (supplied == null) {
            return false;
        }
        Object[] newObjs = supplied instanceof Object[] ? (Object[])supplied : new Object[]{supplied};
        if (newObjs.length == 0) {
            return false;
        }
        for (Object o : newObjs) {
            if (o instanceof Album) continue;
            log.error("Illegal class of album object: " + o.getClass().getName());
            return false;
        }
        this.addAll(pos, Arrays.asList((Album[])Arrays.copyOf(newObjs, newObjs.length, Album[].class)));
        this.save();
        return true;
    }

    public synchronized boolean removeFromModel(int posFrom, int posTo) {
        this.removeRange(posFrom, posTo);
        this.save();
        return true;
    }

    public synchronized int getItemCount() {
        return this.size();
    }

    public synchronized Album getItem(int index) {
        return (Album)this.get(index);
    }

    public synchronized void refresh() {
    }
}

