/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.news.layouts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.news.App;
import org.luwrain.app.news.Strings;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Area;
import org.luwrain.core.Luwrain;
import org.luwrain.pim.news.persist.Group;

public final class GroupPropertiesLayout
extends LayoutBase {
    private static final String NAME = "name";
    private static final String ORDER_INDEX = "order-index";
    private static final String EXPIRE_AFTER_DAYS = "expire-after-days";
    private static final String ALWAYS_SHOW = "always-show";
    private final App app;
    final FormArea formArea;

    public GroupPropertiesLayout(App app, Group group, LayoutBase.ActionHandler closing) {
        super((AppBase)app);
        this.app = app;
        Strings s = (Strings)app.getStrings();
        this.formArea = new FormArea(this.getControlContext(), s.groupPropertiesAreaName(group.getName()));
        List<String> urls = Objects.requireNonNullElse(group.getUrls(), Arrays.asList(new String[0]));
        urls = new ArrayList<String>(urls.stream().map(e -> e.trim()).filter(e -> !e.isEmpty()).toList());
        urls.add("");
        this.formArea.addEdit(NAME, s.groupPropertiesName(), group.getName());
        this.formArea.addEdit(ORDER_INDEX, s.groupPropertiesOrderIndex(), "" + group.getOrderIndex());
        this.formArea.addMultilineEdit(s.groupPropertiesUrls(), urls, true);
        this.setCloseHandler(closing);
        this.setOkHandler(() -> {
            if (!this.save(group)) {
                return true;
            }
            return closing.onAction();
        });
        this.setAreaLayout((Area)this.formArea, this.actions(new LayoutBase.ActionInfo[0]));
    }

    private boolean save(Group group) {
        int orderIndexValue;
        String name = this.formArea.getEnteredText(NAME);
        String orderIndex = this.formArea.getEnteredText(ORDER_INDEX);
        if (name.trim().isEmpty()) {
            this.app.message(((Strings)this.app.getStrings()).groupPropertiesNameCannotBeEmpty(), Luwrain.MessageType.ERROR);
            return false;
        }
        group.setName(name);
        if (orderIndex.trim().isEmpty()) {
            this.app.message(((Strings)this.app.getStrings()).groupPropertiesInvalidOrderIndex(), Luwrain.MessageType.ERROR);
            return false;
        }
        try {
            orderIndexValue = Integer.parseInt(orderIndex.trim());
        }
        catch (NumberFormatException e2) {
            this.app.message(((Strings)this.app.getStrings()).groupPropertiesInvalidOrderIndex(), Luwrain.MessageType.ERROR);
            return false;
        }
        if (orderIndexValue < 0) {
            this.app.message(((Strings)this.app.getStrings()).groupPropertiesInvalidOrderIndex(), Luwrain.MessageType.ERROR);
            return false;
        }
        group.setOrderIndex(orderIndexValue);
        List<String> urls = Arrays.asList(this.formArea.getMultilineEditText());
        group.setUrls(urls.stream().map(e -> e.trim()).filter(e -> !e.isEmpty()).toList());
        this.app.persist.getGroupDAO().update(group);
        return true;
    }
}

