/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.luwrain.core.Launcher;
import org.luwrain.core.NullCheck;

public final class Init {
    private static final File DEBUG_FILE = new File(new File(System.getProperty("user.home")), "luwrain-debug.txt");

    public static void main(String[] args) throws IOException {
        Launcher launcher;
        if (DEBUG_FILE.exists() && !DEBUG_FILE.isDirectory()) {
            PrintStream log = new PrintStream(new BufferedOutputStream(new FileOutputStream(DEBUG_FILE)), true);
            System.setOut(log);
            System.setErr(log);
        }
        File appDir = null;
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("--app-dir")) continue;
            appDir = new File(args[i + 1]);
            break;
        }
        if (appDir == null) {
            appDir = new File(".");
        }
        File userHomeDir = new File(System.getProperty("user.home"));
        ArrayList<URL> urls = new ArrayList<URL>();
        Init.addJarsToClassPath(new File(appDir, "lib"), urls);
        URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        File dataDir = new File("data");
        try {
            Object obj = Class.forName("org.luwrain.core.LauncherImpl", true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            launcher = (Launcher)obj;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        launcher.launch(args);
    }

    private static void addExtensionsJarsToClassPath(File extensionsDir, List<URL> urls) {
        NullCheck.notNull(extensionsDir, "extensionsDir");
        NullCheck.notNull(urls, "urls");
        File[] subdirs = extensionsDir.listFiles();
        if (subdirs == null) {
            return;
        }
        for (File s : subdirs) {
            File jarsDir;
            if (!s.isDirectory() || !(jarsDir = new File(s, "jar")).isDirectory()) continue;
            Init.addJarsToClassPath(jarsDir, urls);
        }
    }

    private static void addJarsToClassPath(File file, List<URL> urls) {
        try {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                if (f.isDirectory() || !f.getName().toLowerCase().trim().endsWith(".jar")) continue;
                URL url = f.toURI().toURL();
                urls.add(url);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

