/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.proj.single;

import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.Project;
import org.luwrain.studio.edit.tex.TexSourceFile;

public final class SingleFileProject
implements Project {
    private static final Logger log = LogManager.getLogger();
    final IDE ide;
    final File projDir;
    final File sourceFile;
    private final Part mainPart;

    public SingleFileProject(IDE ide, File sourceFile) {
        NullCheck.notNull((Object)ide, (String)"ide");
        NullCheck.notNull((Object)sourceFile, (String)"sourceFile");
        this.ide = ide;
        this.sourceFile = sourceFile;
        this.projDir = this.sourceFile.getParentFile();
        if (!sourceFile.getName().toUpperCase().endsWith(".TEX")) {
            throw new IllegalArgumentException("Unable to choose proper project type: " + sourceFile.getName());
        }
        log.trace("Creating a single file project: dir=" + sourceFile.getParentFile().getAbsolutePath() + ", file=" + sourceFile.getName());
        TexSourceFile p = new TexSourceFile(sourceFile.getName(), sourceFile.getName());
        p.init(this, ide);
        this.mainPart = p;
    }

    @Override
    public File getProjectDir() {
        return this.projDir;
    }

    @Override
    public void close() {
    }

    @Override
    public Part getPartsRoot() {
        return this.mainPart;
    }

    @Override
    public Part getMainSourceFile() {
        return this.mainPart;
    }

    @Override
    public Project load(File file, IDE ide) throws IOException {
        return null;
    }
}

