/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.edit.java;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.MutableMarkedLinesImpl;
import org.luwrain.controls.edit.DefaultEditAreaAppearance;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.Part;
import org.luwrain.studio.TextEditing;
import org.luwrain.util.FileUtils;
import org.luwrain.util.TextUtils;

final class Editing
implements TextEditing {
    private final File file;
    private final MutableMarkedLinesImpl content;

    Editing(File file) throws IOException {
        NullCheck.notNull((Object)file, (String)"files");
        this.file = file;
        String text = FileUtils.readTextFile((File)file);
        String[] lines = TextUtils.splitLines((String)text);
        this.content = new MutableMarkedLinesImpl(lines);
    }

    @Override
    public EditArea.Params getEditParams(ControlContext context) {
        EditArea.Params params = new EditArea.Params();
        params.context = context;
        params.content = this.content;
        params.appearance = new DefaultEditAreaAppearance(context);
        params.editFactory = editParams -> new MultilineEdit(editParams);
        params.name = this.file.getName();
        return params;
    }

    @Override
    public boolean save() throws IOException {
        return false;
    }

    @Override
    public Part.Action[] getActions() {
        return new Part.Action[0];
    }

    @Override
    public void onNewHotPoint(int hotPointX, int hotPointY) {
    }

    @Override
    public void closeEditing() {
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public void onModification() {
    }

    @Override
    public AtomicBoolean getModifiedFlag() {
        return null;
    }

    @Override
    public boolean hasSameSource(org.luwrain.studio.Editing editing) {
        return false;
    }
}

