/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.backends.tex;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.core.HookContainer;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.script.controls.EditCorrectorHooks;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.backends.tex.TexAppearance;
import org.luwrain.studio.backends.tex.TexNewLineIndent;
import org.luwrain.studio.edit.TextEditingBase;

final class TexEditing
extends TextEditingBase {
    private static final String HOOK_EDIT = "luwrain.studio.tex";

    TexEditing(IDE ide, File file) throws IOException {
        super(ide, file);
    }

    @Override
    public Part.Action[] getActions() {
        return Part.actions(Part.action("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u043b\u0430\u0439\u0434", new InputEvent('f', EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::addFrame), Part.action("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u0435\u043d\u0443\u043c\u0435\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a", new InputEvent('u', EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::addItemize), Part.action("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u0435\u043d\u0443\u043c\u0435\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a", new InputEvent('o', EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::addEnumerate), Part.action("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0438\u0441\u043a\u0430", new InputEvent('i', EnumSet.of(InputEvent.Modifiers.ALT, InputEvent.Modifiers.SHIFT)), this::addItem));
    }

    @Override
    public MutableMarkedLines getContent() {
        return null;
    }

    @Override
    public AtomicBoolean getModified() {
        return null;
    }

    private boolean addFrame(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        if (!this.insertText(new String[]{"\\begin{frame}", "  \\frametitle{}", "\\end{frame}"})) {
            return false;
        }
        ide.getLuwrainObj().message("frame", Luwrain.MessageType.OK);
        return true;
    }

    private boolean addItemize(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        if (!this.insertText(new String[]{"\\begin{itemize}", "\\item{}", "\\end{itemize}"})) {
            return false;
        }
        ide.getLuwrainObj().message("Itemize", Luwrain.MessageType.OK);
        return true;
    }

    private boolean addEnumerate(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        if (!this.insertText(new String[]{"\\begin{enumerate}", "\\item{}", "\\end{enumerate}"})) {
            return false;
        }
        ide.getLuwrainObj().message("Enumerate", Luwrain.MessageType.OK);
        return true;
    }

    private boolean addItem(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        if (!this.insertText("\\item{}")) {
            return false;
        }
        ide.getLuwrainObj().message("item", Luwrain.MessageType.OK);
        return true;
    }

    @Override
    public EditArea.Params getEditParams(ControlContext context) {
        EditArea.Params params = new EditArea.Params();
        params.context = context;
        params.content = this.getContent();
        params.appearance = new TexAppearance(context);
        params.inputEventListeners = new ArrayList<EditArea.InputEventListener>(Arrays.asList(this.createEditAreaInputEventHook()));
        params.editFactory = editParams -> {
            editParams.model = new EditCorrectorHooks((HookContainer)this.ide.getScriptCore(), (MultilineEdit.Model)new TexNewLineIndent(editParams.model), HOOK_EDIT);
            return this.getEdit();
        };
        params.name = this.file.getName();
        return params;
    }
}

