/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.backends.tex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.CompilationException;
import org.luwrain.studio.backends.tex.TexCompilation;

final class CompilationCommandFactory {
    CompilationCommandFactory() {
    }

    ProxyExecutable newCompilationCommand(TexCompilation compilation, String commandName) {
        NullCheck.notNull((Object)compilation, (String)"compilation");
        NullCheck.notEmpty((Object)commandName, (String)"commandName");
        return args -> {
            ArrayList<String> argsArray = new ArrayList<String>();
            for (Value v : args) {
                if (v == null) {
                    throw new NullPointerException(commandName + ": Args can't include nulls");
                }
                argsArray.add(v.toString());
            }
            this.run(compilation, commandName, argsArray.toArray(new String[argsArray.size()]));
            return null;
        };
    }

    private void run(TexCompilation compilation, String commandName, String[] args) {
        NullCheck.notNull((Object)compilation, (String)"compilation");
        NullCheck.notEmpty((Object)commandName, (String)"commandName");
        NullCheck.notNullItems((Object[])args, (String)"args");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(commandName);
        cmd.addAll(Arrays.asList(args));
        try {
            Process process = new ProcessBuilder(cmd).directory(compilation.getProjectDir()).start();
        }
        catch (IOException e) {
            throw new CompilationException(e);
        }
    }
}

