/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio;

import groovy.util.Eval;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.studio.Strings;
import org.luwrain.controls.WizardArea;
import org.luwrain.controls.wizard.WizardGroovyController;
import org.luwrain.core.Area;
import org.luwrain.io.json.PersonalInfo;
import org.luwrain.studio.IDE;
import org.luwrain.studio.proj.main.ProjectImpl;
import org.luwrain.util.ResourceUtils;

public final class ProjectWizard
extends LayoutBase {
    private static final Logger log = LogManager.getLogger();
    final IDE ide;
    final File destDir;
    final WizardArea wizardArea;
    final WizardGroovyController controller;

    ProjectWizard(final IDE ide, final Strings strings, final File destDir, String scriptName) {
        super(ide.getAppBase());
        this.ide = ide;
        this.destDir = destDir;
        this.wizardArea = new WizardArea(this.getControlContext());
        this.wizardArea.setAreaName("\u041d\u043e\u0432\u044b\u0439 \u043f\u0440\u043e\u0435\u043a\u0442");
        PersonalInfo persInfo = (PersonalInfo)this.getLuwrain().loadConf(PersonalInfo.class);
        if (persInfo == null) {
            persInfo = new PersonalInfo();
        }
        final HashMap<String, String> values = new HashMap<String, String>();
        values.put("authors", Objects.requireNonNullElse(persInfo.getFullName(), ""));
        this.controller = new WizardGroovyController(this.getLuwrain(), this.wizardArea){

            public void setValue(String name, String value) {
                values.put(name, value);
            }

            public String getValue(String name) {
                String res = (String)values.get(name);
                return res != null ? res : "";
            }

            public void writeFile(String fileName, List<String> lines) {
            }

            public void finish(String fileName, ProjectImpl proj) {
                File file = new File(destDir, fileName);
                proj.setProjectFile(file);
                proj.save();
                ide.loadProject(file);
            }

            public Strings getStrings() {
                return strings;
            }
        };
        try {
            Eval.me((String)"wizard", (Object)this.controller, (String)ResourceUtils.getStringResource(((Object)((Object)this)).getClass(), (String)scriptName));
        }
        catch (IOException ex) {
            log.error("Unable to run project wizard script", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        this.setAreaLayout((Area)this.wizardArea, null);
    }
}

