/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.js;

import java.util.Arrays;
import org.graalvm.polyglot.PolyglotException;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.js.App;
import org.luwrain.app.js.Script;
import org.luwrain.controls.edit.DefaultEditAreaAppearance;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.core.Area;
import org.luwrain.core.ExtensionException;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.ScriptSource;
import org.luwrain.core.ScriptText;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

final class MainLayout
extends LayoutBase {
    private final App app;
    final EditArea editArea;
    private Script script = null;

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        this.script = app.getScripts().scripts.get(0);
        if (this.script.text == null) {
            this.script.text = Arrays.asList(new String[0]);
        }
        this.editArea = new EditArea(this.editParams(params -> {
            params.appearance = new DefaultEditAreaAppearance(this.getControlContext(), Luwrain.SpeakableTextType.PROGRAMMING);
        })){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case SAVE: {
                            return MainLayout.this.save();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.editArea.setText(this.script.text.toArray(new String[this.script.text.size()]));
        this.setAreaLayout((Area)this.editArea, this.actions(new LayoutBase.ActionInfo[]{this.action("run", "\u0418\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u044c", new InputEvent(InputEvent.Special.F9), this::run)}));
    }

    private boolean run() {
        String id;
        ScriptText s = new ScriptText(Arrays.asList(this.editArea.getText()).stream().reduce("", (a, b) -> a + System.lineSeparator() + b));
        try {
            id = this.getLuwrain().loadScript((ScriptSource)s);
        }
        catch (ExtensionException e) {
            Throwable throwable;
            if (e.getCause() != null && (throwable = e.getCause()) instanceof PolyglotException) {
                PolyglotException p = (PolyglotException)throwable;
                this.app.crash((Throwable)p);
            } else {
                this.app.crash(e);
            }
            return true;
        }
        Log.debug((String)"proba", (String)id);
        return true;
    }

    private boolean save() {
        this.script.text = Arrays.asList(this.editArea.getText());
        this.app.save();
        this.app.message("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e", Luwrain.MessageType.OK);
        return true;
    }
}

