/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander.popups;

import java.nio.file.Path;
import java.util.EnumSet;
import org.luwrain.app.commander.Strings;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.popups.FileAcceptance;
import org.luwrain.popups.FilePopup;
import org.luwrain.popups.Popups;

public final class DestPathPopup
extends FilePopup {
    private final Type type;
    private final Strings strings;

    public DestPathPopup(Luwrain luwrain, Strings strings, Type type, Path srcDir, Path[] files, Path destDir) {
        super(luwrain, DestPathPopup.name(strings, type), DestPathPopup.prefix(strings, type, files), DestPathPopup.acceptance(), destDir.toFile(), srcDir.toFile(), EnumSet.noneOf(FilePopup.Flags.class), Popups.DEFAULT_POPUP_FLAGS);
        NullCheck.notNull((Object)strings, (String)"strings");
        NullCheck.notNull((Object)((Object)type), (String)"type");
        this.strings = strings;
        this.type = type;
    }

    private static FileAcceptance acceptance() {
        return (file, announce) -> true;
    }

    private static String name(Strings strings, Type type) {
        NullCheck.notNull((Object)strings, (String)"strings");
        NullCheck.notNull((Object)((Object)type), (String)"type");
        switch (type) {
            case COPY: {
                return strings.copyPopupName();
            }
            case MOVE: {
                return strings.movePopupName();
            }
        }
        return null;
    }

    private static String prefix(Strings strings, Type type, Path[] files) {
        NullCheck.notNull((Object)strings, (String)"strings");
        NullCheck.notNull((Object)((Object)type), (String)"type");
        NullCheck.notNullItems((Object[])files, (String)"files");
        switch (type) {
            case COPY: {
                return strings.copyPopupPrefix(files.length > 1 ? "" : files[0].getFileName().toString()).replaceAll("  ", " ");
            }
            case MOVE: {
                return strings.movePopupPrefix(files.length > 1 ? "" : files[0].getFileName().toString()).replaceAll("  ", " ");
            }
        }
        return "";
    }

    public static enum Type {
        COPY,
        MOVE;

    }
}

