/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander;

import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import java.util.TreeSet;
import org.luwrain.app.commander.App;
import org.luwrain.app.commander.Strings;
import org.luwrain.app.commander.popups.DestPathPopup;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.popups.Popups;

final class Conv {
    private final Luwrain luwrain;
    private final Strings strings;
    private final Set<String> runHistory = new TreeSet<String>();

    Conv(App app) {
        this.luwrain = app.getLuwrain();
        this.strings = (Strings)app.getStrings();
    }

    Path copy(Path copyFromDir, Path[] filesToCopy, Path copyTo) {
        DestPathPopup popup = new DestPathPopup(this.luwrain, this.strings, DestPathPopup.Type.COPY, copyFromDir, filesToCopy, copyTo);
        this.luwrain.popup((Popup)popup);
        if (popup.wasCancelled()) {
            return null;
        }
        return popup.result().toPath();
    }

    Path move(Path moveFromDir, Path[] filesToMove, Path moveTo) {
        DestPathPopup popup = new DestPathPopup(this.luwrain, this.strings, DestPathPopup.Type.MOVE, moveFromDir, filesToMove, moveTo);
        this.luwrain.popup((Popup)popup);
        if (popup.wasCancelled()) {
            return null;
        }
        return popup.result().toPath();
    }

    File mkdirPopup(File createIn) {
        File res = Popups.path((Luwrain)this.luwrain, (String)this.strings.mkdirPopupName(), (String)this.strings.mkdirPopupPrefix(), (File)createIn, (fileToCheck, announce) -> {
            NullCheck.notNull((Object)fileToCheck, (String)"fileToCheck");
            if (fileToCheck.exists()) {
                if (announce) {
                    this.luwrain.message(this.strings.enteredPathExists(fileToCheck.getAbsolutePath()), Luwrain.MessageType.ERROR);
                }
                return false;
            }
            return true;
        });
        return res != null ? res : null;
    }

    boolean deleteConfirmation(Path[] files) {
        String text = this.strings.delPopupText(this.luwrain.i18n().getNumberStr(files.length, "items"));
        return Popups.confirmDefaultNo((Luwrain)this.luwrain, (String)this.strings.delPopupName(), (String)text);
    }

    String ftpAddress() {
        return Popups.text((Luwrain)this.luwrain, (String)this.strings.ftpConnectPopupName(), (String)this.strings.ftpConnectPopupText(), (String)"ftp://");
    }

    File leftPanelVolume() {
        return Popups.disks((Luwrain)this.luwrain, (String)this.strings.leftPanelVolumePopupName());
    }

    File rightPanelVolume() {
        return Popups.disks((Luwrain)this.luwrain, (String)this.strings.rightPanelVolumePopupName());
    }

    String run() {
        return Popups.editWithHistory((Luwrain)this.luwrain, (String)"\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c", (String)"\u041a\u043e\u043c\u0430\u043d\u0434\u0430:", (String)"", this.runHistory);
    }
}

