/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.linux_rec;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.linux_rec.Config;
import org.luwrain.app.linux_rec.Entry;
import org.luwrain.app.linux_rec.MainLayout;
import org.luwrain.app.linux_rec.Strings;
import org.luwrain.core.Application;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.MonoApp;

public final class App
extends AppBase<Strings>
implements MonoApp {
    public static final Path REC_DIR = Paths.get(System.getProperty("user.home"), new String[0]).resolve("Recordings");
    public static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
    public Config conf;
    private MainLayout mainLayout = null;

    public App() {
        super(Strings.class);
    }

    protected AreaLayout onAppInit() throws IOException {
        Files.createDirectories(REC_DIR, new FileAttribute[0]);
        this.conf = (Config)this.getLuwrain().loadConf(Config.class);
        if (this.conf == null) {
            this.conf = new Config();
        }
        this.conf.entries = this.conf.entries != null ? new ArrayList<Entry>(this.conf.entries) : new ArrayList<Entry>();
        this.mainLayout = new MainLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        return this.mainLayout.getAreaLayout();
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public MonoApp.Result onMonoAppSecondInstance(Application app) {
        return MonoApp.Result.BRING_FOREGROUND;
    }
}

