/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.notepad;

import org.luwrain.app.notepad.Settings;
import org.luwrain.app.notepad.Strings;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;

final class SettingsForm
extends FormArea
implements SectionArea {
    private ControlPanel controlPanel;
    private Luwrain luwrain;
    private Settings sett;
    private Strings strings;

    SettingsForm(ControlPanel controlPanel, Strings strings) {
        super((ControlContext)new DefaultControlContext(controlPanel.getCoreInterface()), strings.settingsFormName());
        this.controlPanel = controlPanel;
        this.luwrain = controlPanel.getCoreInterface();
        this.strings = strings;
        this.sett = null;
        this.fillForm();
    }

    private void fillForm() {
        this.addEdit("narrating-channel-name", this.strings.settingsFormNarratingChannelName(), this.sett.getNarratingChannelName(""));
        this.addEdit("narrating-channel-params", this.strings.settingsFormNarratingChannelParams(), this.sett.getNarratingChannelParams(""));
        this.addEdit("narrated-file-len", this.strings.settingsFormNarratedFileLen(), String.valueOf(this.sett.getNarratedFileLen(0)));
        this.addEdit("narrating-speech-pitch", this.strings.settingsFormNarratingSpeechPitch(), String.valueOf(this.sett.getNarratingSpeechPitch(0)));
        this.addEdit("narrating-speech-rate", this.strings.settingsFormNarratingSpeechRate(), String.valueOf(this.sett.getNarratingSpeechRate(0)));
        this.addEdit("narrating-pause-duration", this.strings.settingsFormNarratingPauseDuration(), String.valueOf(this.sett.getNarratingPauseDuration(0)));
    }

    public boolean saveSectionData() {
        int value;
        this.sett.setNarratingChannelName(this.getEnteredText("narrating-channel-name"));
        this.sett.setNarratingChannelParams(this.getEnteredText("narrating-channel-params"));
        try {
            value = Integer.parseInt(this.getEnteredText("narrated-file-len"));
            if (value < 0) {
                this.luwrain.message(this.strings.settingsFormFileLenMayNotBeNegative(), Luwrain.MessageType.ERROR);
                return false;
            }
            this.sett.setNarratedFileLen(value);
        }
        catch (NumberFormatException e) {
            this.luwrain.message(this.strings.settingsFormFileLenIsNotInteger(), Luwrain.MessageType.ERROR);
            return false;
        }
        try {
            value = Integer.parseInt(this.getEnteredText("narrating-speech-pitch"));
            if (value < -50 || value > 50) {
                this.luwrain.message("fixme", Luwrain.MessageType.ERROR);
                return false;
            }
            this.sett.setNarratingSpeechPitch(value);
        }
        catch (NumberFormatException e) {
            this.luwrain.message("fixme" + e.getMessage(), Luwrain.MessageType.ERROR);
            return false;
        }
        try {
            value = Integer.parseInt(this.getEnteredText("narrating-speech-rate"));
            if (value < -50 || value > 50) {
                this.luwrain.message("fixme", Luwrain.MessageType.ERROR);
                return false;
            }
            this.sett.setNarratingSpeechRate(value);
        }
        catch (NumberFormatException e) {
            this.luwrain.message("fixme" + e.getMessage(), Luwrain.MessageType.ERROR);
            return false;
        }
        try {
            value = Integer.parseInt(this.getEnteredText("narrating-pause-duration"));
            if (value < 0) {
                this.luwrain.message("fixme", Luwrain.MessageType.ERROR);
                return false;
            }
            this.sett.setNarratingPauseDuration(value);
        }
        catch (NumberFormatException e) {
            this.luwrain.message("fixme" + e.getMessage(), Luwrain.MessageType.ERROR);
            return false;
        }
        return true;
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    static SettingsForm create(ControlPanel controlPanel) {
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        Strings strings = (Strings)controlPanel.getCoreInterface().i18n().getStrings(Strings.class.getName());
        return new SettingsForm(controlPanel, strings);
    }
}

