/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.notepad;

import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.notepad.App;
import org.luwrain.app.notepad.Strings;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.SimpleArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

final class PropertiesLayout
extends LayoutBase {
    private final App app;
    private final SimpleArea propsArea;

    PropertiesLayout(final App app, String[] lines, final Runnable closing) {
        NullCheck.notNull((Object)((Object)app), (String)"app");
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        NullCheck.notNull((Object)closing, (String)"closing");
        this.app = app;
        this.propsArea = new SimpleArea((ControlContext)new DefaultControlContext(app.getLuwrain()), ((Strings)app.getStrings()).propsAreaName()){

            public boolean onInputEvent(InputEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (app.onInputEvent((Area)this, event, closing)) {
                    return true;
                }
                return super.onInputEvent(event);
            }

            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (app.onSystemEvent((Area)this, event)) {
                    return true;
                }
                return super.onSystemEvent(event);
            }

            public boolean onAreaQuery(AreaQuery query) {
                NullCheck.notNull((Object)query, (String)"query");
                if (app.onAreaQuery((Area)this, query)) {
                    return true;
                }
                return super.onAreaQuery(query);
            }
        };
        this.propsArea.update(text -> {
            text.addLine("");
            for (String s : lines) {
                text.addLine(s);
            }
            text.addLine("");
        });
    }

    AreaLayout getLayout() {
        return new AreaLayout((Area)this.propsArea);
    }
}

