/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import uk.co.jemos.podam.api.ClassAttribute;

@Immutable
public class ClassInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> className;
    private final Set<ClassAttribute> classAttributes = new HashSet<ClassAttribute>();
    private final List<Method> extraMethods = new ArrayList<Method>();

    public ClassInfo(Class<?> className, Collection<ClassAttribute> classAttributes) {
        this(className, classAttributes, Collections.emptyList());
    }

    public ClassInfo(Class<?> className, Collection<ClassAttribute> classAttributes, Collection<Method> extraMethods) {
        this.className = className;
        this.classAttributes.addAll(classAttributes);
        this.extraMethods.addAll(extraMethods);
    }

    public Set<ClassAttribute> getClassAttributes() {
        return new HashSet<ClassAttribute>(this.classAttributes);
    }

    public Class<?> getClassName() {
        return this.className;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.classAttributes.hashCode();
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassInfo)) {
            return false;
        }
        ClassInfo other = (ClassInfo)obj;
        if (!this.classAttributes.equals(other.classAttributes)) {
            return false;
        }
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }
}

