/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.windows;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.luwrain.core.Luwrain;
import org.luwrain.popups.DisksPopup;

public final class DefaultDisksPopupFactory
implements DisksPopup.Factory {
    public DisksPopup.Disks newDisks(Luwrain luwrain) {
        return new DisksImpl();
    }

    private final class DisksImpl
    implements DisksPopup.Disks {
        private DisksImpl() {
        }

        public DisksPopup.Disk[] getDisks(Set<DisksPopup.Flags> flags) {
            ArrayList<DiskImpl> res = new ArrayList<DiskImpl>();
            File[] roots = File.listRoots();
            if (roots != null) {
                for (File f : roots) {
                    res.add(new DiskImpl(f.getAbsolutePath()));
                }
            }
            return res.toArray(new DisksPopup.Disk[res.size()]);
        }
    }

    private final class DiskImpl
    implements DisksPopup.Disk {
        final String title;
        final String path;

        DiskImpl(String path) {
            this.title = path;
            this.path = path;
        }

        public boolean isActivated() {
            return true;
        }

        public File activate(Set<DisksPopup.Flags> flags) {
            return new File(this.path);
        }

        public boolean deactivate(Set<DisksPopup.Flags> flags) {
            return true;
        }

        public boolean poweroff(Set<DisksPopup.Flags> flags) {
            return true;
        }

        public String toString() {
            return this.title;
        }
    }
}

