/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.util.LinkedList;
import org.luwrain.core.NullCheck;

public class TextAligning {
    final int maxLineLen;
    public int origHotPointX = -1;
    public int origHotPointY = -1;
    public String[] origLines = new String[0];
    public int hotPointX = -1;
    public int hotPointY = -1;
    public final LinkedList<String> res = new LinkedList();

    public TextAligning(int maxLineLen) {
        if (maxLineLen < 0) {
            throw new IllegalArgumentException("maxLineLen (" + maxLineLen + ") may not be negative");
        }
        this.maxLineLen = maxLineLen;
    }

    public void align() {
        this.res.clear();
        this.hotPointX = -1;
        this.hotPointY = -1;
        boolean wereSpaces = false;
        boolean wereSpacesWithHotPoint = false;
        for (int lineIndex = 0; lineIndex < this.origLines.length; ++lineIndex) {
            String line = this.origLines[lineIndex];
            if (line.isEmpty()) continue;
            int pos = 0;
            while (pos < line.length()) {
                int wordBeginPos = pos;
                while (pos < line.length() && !Character.isSpaceChar(line.charAt(pos))) {
                    ++pos;
                }
                if (pos > wordBeginPos) {
                    int hotPointPos = this.origHotPointY == lineIndex && this.origHotPointX >= wordBeginPos && this.origHotPointX < pos ? this.origHotPointX - wordBeginPos : -1;
                    this.onWord(line.substring(wordBeginPos, pos), hotPointPos, wereSpaces, wereSpacesWithHotPoint);
                    wereSpaces = false;
                    wereSpacesWithHotPoint = false;
                }
                int spaceBeginPos = pos;
                while (pos < line.length() && Character.isSpaceChar(line.charAt(pos))) {
                    ++pos;
                }
                if (pos <= spaceBeginPos) continue;
                wereSpaces = true;
                if (this.origHotPointY != lineIndex || this.origHotPointX < spaceBeginPos || this.origHotPointX >= pos) continue;
                wereSpacesWithHotPoint = true;
            }
            wereSpaces = true;
        }
        if (wereSpaces && wereSpacesWithHotPoint) {
            if (this.res.isEmpty() || this.getLastLineSpaceLeft() == 0) {
                this.res.add(" ");
                this.hotPointX = 0;
                this.hotPointY = this.res.size() - 1;
            } else {
                this.addLastLine(" ");
                this.hotPointX = this.getLastLineLen() - 1;
                this.hotPointY = this.res.size() - 1;
            }
        }
    }

    protected void onWord(String word, int hotPointPos, boolean wereSpaces, boolean wereSpacesWithHotPoint) {
        NullCheck.notEmpty((Object)word, (String)"word");
        if (hotPointPos >= word.length()) {
            throw new IllegalArgumentException("hotPointPos (" + hotPointPos + ") may not be greater than " + word.length());
        }
        if (wereSpacesWithHotPoint && !wereSpaces) {
            throw new IllegalArgumentException("wereSpacesWithHotPoint can be set only with wereSpaces");
        }
        if (this.res.isEmpty()) {
            if (wereSpacesWithHotPoint) {
                this.res.add(" " + word);
                this.hotPointX = 0;
                this.hotPointY = 0;
            } else {
                this.res.add(word);
                if (hotPointPos >= 0) {
                    this.hotPointX = hotPointPos;
                    this.hotPointY = 0;
                }
            }
            return;
        }
        if (wereSpacesWithHotPoint) {
            if (this.getLastLineSpaceLeft() > 0) {
                this.addLastLine(" ");
                this.hotPointX = this.getLastLineLen() - 1;
                this.hotPointY = this.res.size() - 1;
            } else {
                this.res.add(" ");
                this.hotPointX = 0;
                this.hotPointY = this.res.size() - 1;
            }
            this.onWord(word, -1, false, false);
            return;
        }
        if (this.getLastLineSpaceLeft() >= word.length() + (wereSpaces ? 1 : 0)) {
            if (wereSpaces) {
                this.addLastLine(" ");
            }
            int previousLen = this.getLastLineLen();
            this.addLastLine(word);
            if (hotPointPos >= 0) {
                this.hotPointX = previousLen + hotPointPos;
                this.hotPointY = this.res.size() - 1;
            }
            return;
        }
        this.res.add(word);
        if (hotPointPos >= 0) {
            this.hotPointX = hotPointPos;
            this.hotPointY = this.res.size() - 1;
        }
    }

    protected int getLastLineLen() {
        if (this.res.isEmpty()) {
            throw new RuntimeException("res may not be empty");
        }
        return this.res.getLast().length();
    }

    protected int getLastLineSpaceLeft() {
        if (this.res.isEmpty()) {
            throw new RuntimeException("res may not be empty");
        }
        return this.maxLineLen - this.res.getLast().length();
    }

    protected void addLastLine(String text) {
        if (this.res.isEmpty()) {
            throw new RuntimeException("res may not be empty");
        }
        this.res.set(this.res.size() - 1, this.res.getLast() + text);
    }
}

