/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Stream;

public final class TempDir
implements AutoCloseable {
    final Path path;

    public TempDir() {
        try {
            this.path = Files.createTempDirectory(this.getBaseDir(), ".luwrain-", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        try (Stream<Path> s = Files.walk(this.path, new FileVisitOption[0]);){
            ArrayList<Path> l = new ArrayList<Path>(s.toList());
            Collections.reverse(l);
            l.forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public File getFile() {
        return this.path.toFile();
    }

    public Path getPath() {
        return this.path;
    }

    private Path getBaseDir() {
        String env = System.getenv("TMPDIR");
        if (env != null && !env.isEmpty()) {
            return Paths.get(env, new String[0]);
        }
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }
}

