/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.luwrain.core.NullCheck;

public final class ResourceUtils {
    public static List<String> readStringResourceAsList(Class c, String resourceName, String charset) throws IOException {
        Objects.requireNonNull(c, "c can't be null");
        Objects.requireNonNull(resourceName, "resourceName can't be null");
        Objects.requireNonNull(charset, "charset can't be null");
        if (resourceName.isEmpty()) {
            throw new IllegalArgumentException("resourceName can't be empty");
        }
        if (charset.isEmpty()) {
            throw new IllegalArgumentException("charset can't be empty");
        }
        ArrayList<String> res = new ArrayList<String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(c.getResourceAsStream(resourceName), charset));){
            String line = r.readLine();
            while (line != null) {
                res.add(line);
                line = r.readLine();
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
    }

    public static String readStringResource(Class c, String resourceName, String charset, String lineSeparator) throws IOException {
        NullCheck.notNull((Object)c, (String)"c");
        NullCheck.notEmpty((Object)resourceName, (String)"resourceName");
        NullCheck.notEmpty((Object)charset, (String)"charset");
        NullCheck.notEmpty((Object)lineSeparator, (String)"lineSeparator");
        StringBuilder b = new StringBuilder();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(c.getResourceAsStream(resourceName), charset));){
            String line = r.readLine();
            while (line != null) {
                b.append(line).append(lineSeparator);
                line = r.readLine();
            }
            String string = new String(b);
            return string;
        }
    }

    public static String getStringResource(Class c, String resourceName) throws IOException {
        return ResourceUtils.readStringResource(c, resourceName, "UTF-8", System.lineSeparator());
    }
}

