/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

public final class RangeUtils {
    public static boolean between(int pos, int from, int to) {
        return pos >= from && pos < to;
    }

    public static boolean intersects(int start1, int len1, int start2, int len2) {
        if (start1 < start2) {
            return RangeUtils.between(start2, start1, start1 + len1);
        }
        return RangeUtils.between(start1, start2, start2 + len2);
    }

    public static int[] commonRange(int start1, int len1, int start2, int len2) {
        if (!RangeUtils.intersects(start1, len1, start2, len2)) {
            return null;
        }
        if (start1 < start2) {
            return new int[]{start2, Math.min(start1 + len1, start2 + len2)};
        }
        return new int[]{start1, Math.min(start1 + len1, start2 + len2)};
    }

    public static int[] commonRangeByBounds(int from1, int to1, int from2, int to2) {
        return RangeUtils.commonRange(from1, to1 - from1, from2, to2 - from2);
    }
}

