/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.shell.desktop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Supplier;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.EditableListArea;
import org.luwrain.controls.ListArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.UniRefInfo;
import org.luwrain.core.UniRefUtils;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.io.json.CommonSettings;
import org.luwrain.io.json.DesktopItem;
import org.luwrain.shell.Config;
import org.luwrain.shell.desktop.Appearance;
import org.luwrain.shell.desktop.Conversations;

final class DesktopArea
extends EditableListArea<DesktopItem>
implements ListArea.ClickHandler<DesktopItem> {
    private final Luwrain luwrain;

    DesktopArea(Luwrain luwrain, String areaName, Conversations conv) {
        super(DesktopArea.createParams(luwrain, areaName, conv));
        this.luwrain = Objects.requireNonNull(luwrain, "luwrain can't be null");
        this.setListClickHandler(this);
    }

    private static EditableListArea.Params<DesktopItem> createParams(Luwrain luwrain, String areaName, Conversations conv) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        Objects.requireNonNull(areaName, "areaName can't be null");
        Objects.requireNonNull(conv, "conv can't be null");
        EditableListArea.Params<DesktopItem> params = new EditableListArea.Params<DesktopItem>();
        params.context = new DefaultControlContext(luwrain);
        params.model = new Model(luwrain);
        params.appearance = new Appearance(luwrain);
        params.name = areaName;
        params.clipboardSaver = (area, model, appearance, fromIndex, toIndex, clipboard) -> {
            ArrayList<UniRefInfo> u = new ArrayList<UniRefInfo>();
            ArrayList<String> s = new ArrayList<String>();
            for (int i = fromIndex; i < toIndex; ++i) {
                DesktopItem obj = (DesktopItem)model.getItem(i);
                UniRefInfo uniRefInfo = obj.getUniRefInfo(luwrain);
                u.add(uniRefInfo);
                s.add(uniRefInfo.getTitle());
            }
            clipboard.set(u.toArray(new UniRefInfo[u.size()]), s.toArray(new String[s.size()]));
            return true;
        };
        params.confirmation = (area, model, fromIndex, toIndex) -> {
            if (fromIndex + 1 == toIndex) {
                return conv.deleteItem(params.appearance.getScreenAppearance((DesktopItem)model.getItem(fromIndex), EnumSet.noneOf(ListArea.Appearance.Flags.class)));
            }
            return conv.deleteItems(toIndex - fromIndex);
        };
        return params;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        Objects.requireNonNull(event, "event can't be null");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ESCAPE: {
                    return this.onEscape();
                }
            }
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        Objects.requireNonNull(event, "event can't be null");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case HELP: {
                return this.luwrain.openHelp("luwrain.default");
            }
            case CLOSE: {
                this.luwrain.silence();
                this.luwrain.message(this.luwrain.i18n().getStaticStr("DesktopNoApplication"), Sounds.NO_APPLICATIONS);
                return true;
            }
        }
        return super.onSystemEvent(event);
    }

    @Override
    protected String noContentStr() {
        return this.luwrain.getString("STATIC:EmptyDesktop");
    }

    @Override
    public boolean onListClick(ListArea area, int index, DesktopItem item) {
        Objects.requireNonNull(item, "item can't be null");
        UniRefInfo uniRefInfo = item.getUniRefInfo(this.luwrain);
        return this.luwrain.openUniRef(uniRefInfo.getValue());
    }

    private boolean onEscape() {
        CommonSettings conf = this.luwrain.loadConf(CommonSettings.class);
        if (conf == null) {
            return false;
        }
        String cmdName = Objects.requireNonNullElse(conf.getDesktopEscapeCommand(), "");
        if (cmdName.trim().isEmpty()) {
            return false;
        }
        return this.luwrain.runCommand(cmdName.trim());
    }

    private static final class Model
    extends ArrayList<DesktopItem>
    implements EditableListArea.Model<DesktopItem> {
        private final Luwrain luwrain;

        Model(Luwrain luwrain) {
            Objects.requireNonNull(luwrain, "luwrain can't be null");
            this.luwrain = luwrain;
            Config conf = luwrain.loadConf(Config.class);
            if (conf != null) {
                this.addAll(Arrays.asList(DesktopItem.fromJson(conf.getDesktopContent())));
            }
        }

        @Override
        public boolean removeFromModel(int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IllegalArgumentException("fromIndex can't be negative");
            }
            if (toIndex < 0) {
                throw new IllegalArgumentException("toIndex can't be negative");
            }
            if (fromIndex >= this.size() || toIndex > this.size()) {
                return false;
            }
            this.removeRange(fromIndex, toIndex);
            this.save();
            return true;
        }

        @Override
        public boolean addToModel(int index, Supplier<Object> supplier) {
            NullCheck.notNull(supplier, (String)"supplier");
            if (index < 0) {
                throw new IllegalArgumentException("index may not be negative");
            }
            Object supplied = supplier.get();
            if (supplied == null) {
                return false;
            }
            Object[] objs = supplied instanceof Object[] ? (Object[])supplied : new Object[]{supplied};
            if (objs.length == 0) {
                return false;
            }
            ArrayList<DesktopItem> newItems = new ArrayList<DesktopItem>();
            for (Object o : objs) {
                UniRefInfo info = UniRefUtils.make(this.luwrain, o);
                if (info == null) {
                    return false;
                }
                newItems.add(new DesktopItem(info));
            }
            this.addAll(index, newItems);
            this.save();
            return true;
        }

        @Override
        public int getItemCount() {
            return this.size();
        }

        @Override
        public DesktopItem getItem(int index) {
            return (DesktopItem)this.get(index);
        }

        @Override
        public void refresh() {
        }

        private void save() {
            Config conf = this.luwrain.loadConf(Config.class);
            conf.setDesktopContent(DesktopItem.toJson(this.toArray(new DesktopItem[this.size()])));
            this.luwrain.saveConf(conf);
        }
    }
}

