/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.shell.desktop;

import com.google.auto.service.AutoService;
import java.util.Objects;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.InitResult;
import org.luwrain.core.Luwrain;
import org.luwrain.shell.Config;
import org.luwrain.shell.desktop.Conversations;
import org.luwrain.shell.desktop.DesktopArea;
import org.luwrain.shell.desktop.Strings;

@AutoService(value={org.luwrain.core.Desktop.class})
public final class Desktop
implements org.luwrain.core.Desktop {
    private Luwrain luwrain = null;
    private String name = "";
    private DesktopArea desktopArea = null;
    private Strings strings = null;
    private Conversations conv = null;

    @Override
    public InitResult onLaunchApp(Luwrain luwrain) {
        this.luwrain = Objects.requireNonNull(luwrain, "luwrain can't be null");
        Object o = luwrain.i18n().getStrings(Strings.class.getName());
        if (o == null || !(o instanceof Strings)) {
            return new InitResult(InitResult.Type.NO_STRINGS_OBJ, Strings.class.getName());
        }
        this.strings = (Strings)o;
        this.conv = new Conversations(luwrain, this.strings);
        this.name = "";
        Config conf = luwrain.loadConf(Config.class);
        if (conf != null) {
            this.name = Objects.requireNonNullElse(conf.getDesktopTitle(), "").trim();
        }
        if (this.name.isEmpty()) {
            this.name = luwrain.i18n().getStaticStr("Desktop");
        }
        this.desktopArea = new DesktopArea(luwrain, this.name, this.conv);
        return new InitResult();
    }

    @Override
    public String getAppName() {
        return this.name;
    }

    @Override
    public AreaLayout getAreaLayout() {
        return new AreaLayout(this.desktopArea);
    }

    @Override
    public void onAppClose() {
    }
}

