/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;

class SoundSchemes
extends ListArea<Item>
implements SectionArea {
    private static final String SCHEMES_DIR = "sounds/schemes";
    private ControlPanel controlPanel;
    private final ListUtils.FixedModel model = new ListUtils.FixedModel();

    SoundSchemes(ControlPanel controlPanel, ListArea.Params<Item> params) {
        super(params);
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        this.controlPanel = controlPanel;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean saveSectionData() {
        return true;
    }

    private static Item[] loadItems(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        ArrayList<Item> items = new ArrayList<Item>();
        ArrayList<Path> dirs = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(luwrain.getFileProperty("luwrain.dir.data").toPath().resolve(SCHEMES_DIR));){
            for (Path p : directoryStream) {
                if (!Files.isDirectory(p, new LinkOption[0])) continue;
                dirs.add(p);
            }
        }
        catch (IOException e) {
            luwrain.crash(e);
            return new Item[0];
        }
        for (Path p : dirs) {
            String title;
            block13: {
                title = null;
                try {
                    List<String> lines = Files.readAllLines(p.resolve("TITLE." + luwrain.getProperty("luwrain.lang") + ".txt"));
                    if (lines.isEmpty()) break block13;
                    title = lines.get(0);
                }
                catch (Exception e) {
                    Log.warning("control-panel", "unable to read title of the sound scheme in " + p.toString());
                    e.printStackTrace();
                    continue;
                }
            }
            if (title == null || title.trim().isEmpty()) continue;
            items.add(new Item(p, title));
        }
        return items.toArray(new Item[items.size()]);
    }

    static SoundSchemes create(ControlPanel controlPanel) {
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        Luwrain luwrain = controlPanel.getCoreInterface();
        ListArea.Params<Item> params = new ListArea.Params<Item>();
        params.context = new DefaultControlContext(luwrain);
        params.appearance = new ListUtils.DefaultAppearance(params.context, Suggestions.LIST_ITEM);
        params.name = "\u0417\u0432\u0443\u043a\u043e\u0432\u044b\u0435 \u0441\u0445\u0435\u043c\u044b";
        params.model = new ListUtils.FixedModel<Item>(SoundSchemes.loadItems(luwrain));
        return new SoundSchemes(controlPanel, params);
    }

    static class Item {
        final Path path;
        final String title;

        Item(Path path, String title) {
            this.path = path;
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    private static class ClickHandler
    implements ListArea.ClickHandler<Item> {
        private Luwrain luwrain;

        ClickHandler(Luwrain luwrain) {
            this.luwrain = luwrain;
        }

        @Override
        public boolean onListClick(ListArea area, int index, Item item) {
            NullCheck.notNull((Object)item, (String)"item");
            return false;
        }
    }
}

