/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.hooks;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.graalvm.polyglot.Value;
import org.luwrain.core.HookContainer;
import org.luwrain.core.NullCheck;
import org.luwrain.script.HookException;

public class ChainOfResponsibilityHook {
    protected final HookContainer hookContainer;

    public ChainOfResponsibilityHook(HookContainer hookContainer) {
        NullCheck.notNull((Object)hookContainer, (String)"hookContainer");
        this.hookContainer = hookContainer;
    }

    public boolean run(String hookName, Object[] args) throws HookException {
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        NullCheck.notNullItems((Object[])args, (String)"args");
        AtomicBoolean execRes = new AtomicBoolean(false);
        AtomicReference error = new AtomicReference();
        this.hookContainer.runHooks(hookName, hook -> {
            try {
                Object res = hook.run(args);
                if (res == null || !(res instanceof Value)) {
                    return HookContainer.HookResult.CONTINUE;
                }
                Value value = (Value)res;
                if (value.isNull() || !value.isBoolean() || !value.asBoolean()) {
                    return HookContainer.HookResult.CONTINUE;
                }
                execRes.set(true);
                return HookContainer.HookResult.BREAK;
            }
            catch (Throwable e) {
                RuntimeException runtimeEx = !(e instanceof RuntimeException) ? new RuntimeException(e) : (RuntimeException)e;
                error.set(runtimeEx);
                return HookContainer.HookResult.BREAK;
            }
        });
        if (error.get() != null) {
            throw new HookException((Throwable)error.get(), hookName);
        }
        return execRes.get();
    }

    public static boolean run(HookContainer hookContainer, String hookName, Object[] args) throws HookException {
        NullCheck.notNull((Object)hookContainer, (String)"hookContainer");
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        NullCheck.notNullItems((Object[])args, (String)"args");
        return new ChainOfResponsibilityHook(hookContainer).run(hookName, args);
    }
}

